% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/named_triplet.R
\name{get_row_col_index_maps}
\alias{get_row_col_index_maps}
\title{Figure out row and column index maps}
\usage{
get_row_col_index_maps(a_mat, ind_maps)
}
\arguments{
\item{a_mat}{A matrix for which index maps should be determined.}

\item{ind_maps}{A single data frame or a list of two or more data frames
of potential index maps.}
}
\value{
A list of two data frames.
The first data frame is the index map for the rows of \code{a_mat}.
The second data frame is the index map for the columns of \code{a_mat}.
}
\description{
The \code{index_map} argument can take several forms.
This function figures out (for a given \code{a_mat})
the index maps for rows (first data frame in the return list)
and columns (second data frame in the return list).
}
\details{
\code{ind_maps} can be a single data frame,
in which case the single data frame will be applied
to both rows and columns of \code{a_mat}.

\code{ind_maps} can also be a 2-item list,
in which case the first item is applied to rows and the
second item is applied to columns.

Finally, \code{ind_maps} can be a named list of length 2 or more,
in which case the names are interpreted as row or column types.
Names in the \code{ind_maps} list are matched to row and column types
and applied as required.

This is a non-exported function meant only for internal use.
}
