% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulate.Weights.R
\name{Sim.Weights}
\alias{Sim.Weights}
\title{Simulation of weights}
\usage{
Sim.Weights(n, utilities, alpha)
}
\arguments{
\item{n}{number of simulations}

\item{utilities}{utility dataframe, first column is the identifier}

\item{alpha}{concentration parameter for the Dirichlet distribution}
}
\value{
List with data.frames \{simulation, weights\} with total utilities and simulated weights
}
\description{
Simulation of weight following a Dirichlet distribution with a concentration 
parameter. The concentration parameter is given a tentative weights.
}
\details{
Taking advantage of the Dirichlet distribution properties the weights could be 
simulated with a concentration arround given weights.
}
\examples{
library( data.table )
N<-10
utilities<-data.table( id = 1:N, 
                       u1 = runif( N, 0, 1 ), 
                       u2 = runif( N, 0, 1 ), 
                       u3 = runif( N, 0, 1 ),
                       u4 = runif( N, 0, 1 ) )
n<-100
alpha<-c( 0.2, 0.5, 0.1, 0.2 )
S<-Sim.Weights( n, utilities, alpha )
}
\author{
Pedro Guarderas
}
\seealso{
\code{\link{Eval.Utilities}}
}

