% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrapNull.R
\name{bootstrapNull}
\alias{bootstrapNull}
\title{Bootstrap to assess significance}
\usage{
bootstrapNull(
  tab,
  n_rep = 1000,
  interval = c(0, 1),
  tol = 0.000001,
  check_boundary = TRUE,
  cores = 1,
  return_raw = TRUE
)
}
\arguments{
\item{tab}{Dataset of read counts as 3d array of size 3x3x2, genotype in first sample x genotype in second sample x allele in read.}

\item{n_rep}{Number of bootstrap replicates}

\item{interval}{Interval to which each parameter should be constrained}

\item{tol}{Tolerance for convergence}

\item{check_boundary}{If TRUE, explicitly check the boundaries of \code{interval}.}

\item{cores}{Number of CPU cores to use, for parallel calculations.
(If \code{0}, use \code{\link[parallel:detectCores]{parallel::detectCores()}}.)
Alternatively, this can be links to a set of cluster sockets, as
produced by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}

\item{return_raw}{If TRUE, return the raw results. If FALSE, just return the p-value.
Unlink \code{\link[=bootstrapSE]{bootstrapSE()}}, here the default is TRUE.}
}
\value{
If \code{return_raw=FALSE}, a single numeric value (the p-value).If
\code{return_raw=TRUE}, a vector of length \code{n_rep} with the LRT statistics from each
bootstrap replicate.
}
\description{
Perform a parametric bootstrap to assess whether there is significant evidence that a sample is a mixture.
}
\examples{
data(mbmixdata)
# just 100 bootstrap replicates, as an illustration
bootstrapNull(mbmixdata, n_rep=100)

}
\seealso{
\code{\link[=bootstrapSE]{bootstrapSE()}}
}
