% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{coordGenerators}
\alias{coordGenerators}
\alias{coordLHS}
\alias{coordUniform}
\alias{coordGrid}
\title{Coordinate generators.}
\usage{
coordLHS(n, lower = 0, upper = 1, method = NULL)

coordUniform(n, lower, upper)

coordGrid(n, lower, upper)
}
\arguments{
\item{n}{[\code{integer(1)}]\cr
Number of points to generate.}

\item{lower}{[\code{numeric(2)}]\cr
Minimal values for the first and second coordinates respectively.
Default is 0.}

\item{upper}{[\code{numeric(2)}]\cr
Maximal values for the first and second coordinates respectively.
Default is 1.}

\item{method}{[\code{function}]\cr
Function from package \pkg{lhs}.
Default is \code{\link[lhs]{maximinLHS}}.}
}
\value{
[\code{matrix(n, 2)}] Matrix of node coordinates.
}
\description{
Functions for the placement of node coordinates in the
euclidean plane. Function \code{coordLHS} generates a space-filling
latin hypercube sample, \code{coordUniform} samples points from a
bivariate uniform distribution and \code{coordGrid} generates a regular
grid of points.
}
