% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emoa_operators.R
\name{mutSubgraphMST}
\alias{mutSubgraphMST}
\title{Subgraph-mutator for edge list representation.}
\usage{
mutSubgraphMST(ind, sigma = floor(ncol(ind)/2), instance = NULL)
}
\arguments{
\item{ind}{[\code{matrix(2, m)}]\cr
Matrix of edges (each column is one edge).}

\item{sigma}{[\code{integer()}]\cr
Upper bound for the size of the selected subtree.}

\item{instance}{[\code{mcGP}]\cr
Multi-objective graph problem.}
}
\value{
[\code{matrix(2, m)}] Mutated edge list.
}
\description{
\code{mutSubgraphMST} selects a random edge e = (u, v) and traverses
the tree starting form u and v respectively until a connected subtree of at most
\code{sigma} edges is selected. Then the subtree is replaced with the optimal spanning subtree
regarding one of the objectives with equal probability.
}
\seealso{
Evolutionary multi-objective algorithm \code{\link{mcMSTEmoaBG}}

Other mcMST EMOA mutators: \code{\link{mutEdgeExchange}},
  \code{\link{mutUniformPruefer}}
}
