% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getExactFront.R
\name{getExactFront}
\alias{getExactFront}
\title{Enumerate all Pareto-optimal solutions.}
\usage{
getExactFront(instance, obj.fun, enumerator.fun, n.objectives)
}
\arguments{
\item{instance}{[any]\cr
Problem instance.}

\item{obj.fun}{[\code{function(solution, instance)}]\cr
Objective function which expects a numeric vector \code{solution} encoding a
solution candidate and a problem instance \code{instance}. The function should
return a numeric vector of length \code{n.objectives}.}

\item{enumerator.fun}{[\code{function(n)}]\cr
Function to exhaustively generate all possible candidate solutions.
Expects a single integer value n, i.e., the instance size, e.g., the
number of nodes for a graph problem.}

\item{n.objectives}{[\code{integer(1)}]\cr
Number of objectives of problem.}
}
\value{
[\code{list}] List with elements \code{pareto.set} (matrix of Pareto-optimal solutions)
and \code{pareto.front} (matrix of corresponding weight vectors).
}
\description{
Function which expects a problem instance of a combinatorial optimization
problem (e.g., MST), a multi-objective function and a solution enumerator, i.e., a function
which enumerates all possible solutions (e.g., all Pruefer codes in case of a
MST problem) and  determines both the Pareto front and Pareto set by
exhaustive enumeration.
}
\note{
This method exhaustively enumerates all possible solutions
of a given multi-objective combinatorial optimization problem. Thus,
it is limited to small input size due to combinatorial explosion.
}
\examples{
# here we enumerate all Pareto-optimal solutions of a bi-objective mcMST problem
# we use the Pruefer-code enumerator. Thus, we need to define an objective
# function, which is able to handle this type of endcoding
objfunMCMST = function(pcode, instance) {
  getWeight(instance, prueferToEdgeList(pcode))
}

# next we generate a random bi-objective graph
g = genRandomMCGP(5L)

# ... and finally compute the exact front of g
res = getExactFront(g, obj.fun = objfunMCMST, enumerator.fun = enumerateMST, n.objectives = 2L)
\dontrun{
plot(res$pareto.front)
}
}
