\name{getbetap.A}
\alias{getbetap.A}
\title{Momoent Corrected Correlation}
\description{
Computes association statistics, the first four moments of the trend statistic \emph{A} under permutation, and \emph{p}-values based on the Beta density approximation. }
\usage{
getbetap.A(getAmoment.list,A=NULL,fix.obs=F)
}
\arguments{
  \item{getAmoment.list}{A list which contains all the items generated by getAmoment function.}
  \item{A}{The vector \emph{A} is composed of elements \eqn{A_i=\sum_j x_{ij} y_j}. In other words, each \eqn{A_i} is the observed statistic of interest. \code{getbetap.A} also allows the user to input the \emph{A} vector directly. This is useful mainly for debugging purposes, or for obtainting approximate \emph{p}-values across a grid of hypothetical \emph{A} values.}
  \item{fix.obs}{this option itentifies and improves the \emph{p}-values using for \eqn{MCC_1} features with implausibily small \eqn{MCC} \emph{p}-values.}
 }
\details{
  \code{mcc} utilizes a general framework for testing the association between features and clinical variables. It simultaneously performs up to millions of tests by using simple parametric approximations applied to exact permutation moments.}
\value{
  The function returns an object of class \code{mcc}. 
}
\references{ Yi-Hui Zhou, Fred Wright, 2013, \emph{Fast And Robust Association Testing For High-Throughput Testing}, \emph{Submitted}.

    See also the vignette included with this package. }
\author{ Yi-Hui Zhou: \email{yihui_zhou@ncsu.edu} }

\seealso{\code{\link{getAmoment}}, \code{\link{getAkmoment}}, \code{\link{getbetap.A.2}}.}
\examples{
set.seed(1)
m=300
n=30
x=matrix(rnorm(m*n),m,n)
y=c(rep(1,15),rep(2,15))
z=c(rep(1,25),rep(2,5))
output=getbetap.A(getAmoment(x,y,z),A=NULL,fix.obs=FALSE)
#names(output)
#[1] "twosidedp"    "rightp"       "leftp"        "pdouble"      "chebyshev.p" 
#[6] "pt"           "lowest.alpha"
}
