% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.MCCCA.func.R
\name{plot.mccca}
\alias{plot.mccca}
\title{plot \code{mccca} object.}
\usage{
\method{plot}{mccca}(
  x,
  main = "MCCCA result",
  catelabel = NULL,
  classlabel = NULL,
  classlabel.legend = NULL,
  xlim = NULL,
  ylim = NULL,
  sort.clssize = TRUE,
  break.size = NULL,
  output.coord = FALSE,
  connect.cord = TRUE,
  include.variname = TRUE,
  scale.gamma = TRUE,
  scatter.level = 2,
  plot.setting = list(alp.point = 0.3, alp.seg = 0.8, txtsize = 3, txtsize.legend = 10),
  ...
)
}
\arguments{
\item{x}{An object of class \code{mccca}, a list of \code{MCCCA} outputs.}

\item{main}{A character giving the title of biplot.}

\item{catelabel}{A characteristic vector of length Q giving labels for all categories to be displayed on the biplot (Q=\code{sum(q.vec)}). If \code{NULL}, \code{rownames(B)} are used.}

\item{classlabel}{A characteristic vector of length C (C:the number of class) giving labels for all classes to be displayed on the biplot. If \code{NULL}, labels specified in \code{create.MCCCAdata} are used.}

\item{classlabel.legend}{A characteristic vector of length C giving labels for all classes to be used on the legend (this can be longer). If \code{NULL}, \code{classlabel} is used.}

\item{xlim}{A numeric vector of length 2 giving the range of plot on the x (horizontal) axis. If NULL, the range is automatically determined.}

\item{ylim}{A numeric vector of length 2 for the y (vertical) axis (same role as \code{xlim}).}

\item{sort.clssize}{If \code{TRUE}, the class-specific cluster numbers are sorted in the order of cluster size. The default is \code{TRUE}.}

\item{break.size}{An integer vector that adjusts the size of bubble displayed on the legend.}

\item{output.coord}{If \code{TRUE}, the output will be \code{Cocls.mat} and \code{Cocate.mat}. See value.}

\item{connect.cord}{If \code{TRUE}, lines are drawn between original (estimated by MCCCA) coordinates and coordinates moved to avoid overlap.}

\item{include.variname}{If \code{TRUE}, variable name is included in category labels in the biplot (ex.a point of category "male" in "v1"(the name of 1st variable) is displayed as "v1:male" on the biplot).}

\item{scale.gamma}{If \code{TRUE}, quantifications are scaled such that the average squared deviation from the origin of the row and column points is the same (See section 2.3 in the paper).}

\item{scatter.level}{A numeric value that adjusts the scatter of points in the biplot. The higher the value, the more scattered the points are. The default is 2.}

\item{plot.setting}{A list of biplot settings. See details.}

\item{\dots}{Additional arguments passed to \code{\link{print}}.}
}
\value{
If \code{output.coord} is \code{TRUE}, returns a list with the following elements.
\item{\code{Cocls.mat}}{A (Kx4) coordinate matrix of clusters, where the last two columns are the coordinates estimated by MCCCA, and the first two columns are the coordinates moved from the estimated coordinates to prevent overlap.}
\item{\code{Cocate.mat}}{A (Kx4) coordinate matrix of categories (each column plays the same role as \code{Cocls.mat}) }
}
\description{
plot \code{mccca} object.
}
\details{
Parameters in \code{plot.setting} are as follows:

-\code{alp.point}:A numeric value from 0 to 1 which adjusts the transparency of the bubble point. The default is 0.3.

-\code{alp.seg}:A numeric value from 0 to 1 which adjusts the transparency of the segments between texts and points. The default is 0.8.

-\code{txtsize}:A numeric value which adjusts the textsize on the biplot. The default is 3.

-\code{txtsize.legend}:A numeric value which adjusts the textsize of the legend on the biplot. The default is 10.
}
\examples{
#setting
N <- 100 ; J <- 5 ; Ktrue <- 2 ; q.vec <- rep(5,J) ; noise.prop <- 0.2
extcate.vec=c(2,3)#the number of categories for each external variable

#generate categorical variable data
catedata.list <- generate.onedata(N=N,J=J,Ktrue=Ktrue,q.vec=q.vec,noise.prop = noise.prop)
data.cate=catedata.list$data.mat
clstr0.vec=catedata.list$clstr0.vec
#generate external variable data
data.ext=generate.ext(N,extcate.vec=extcate.vec)

#create mccca.list to be applied to MCCCA function
mccca.data=create.MCCCAdata(data.cate,ext.mat=data.ext,clstr0.vec =clstr0.vec)

#specify the number of cluster for each of C classes
C=length(mccca.data$data.list)
K.vec=rep(2,C)
#apply MCCCA
mccca.res=MCCCA(mccca.data,K.vec=K.vec)

#plot MCCCA result
plot(mccca.res)
}
\references{
Takagishi & Michel van de Velden (2022): Visualizing Class Specific
Heterogeneous Tendencies in Categorical Data, Journal of Computational and Graphical Statistics,
DOI: 10.1080/10618600.2022.2035737
}
\seealso{
\code{\link{MCCCA}}
}
