% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mccf1.R
\name{mccf1}
\alias{mccf1}
\title{MCC (Matthews correlation coefficient) - F1}
\usage{
mccf1(response, predictor)
}
\arguments{
\item{response}{a vector of actual values (0 or 1) in binary classification.}

\item{predictor}{a vector of predicted values (between 0 and 1) in binary classification.}
}
\value{
the "mccf1" object, which is basically a list containing a vector of thresholds, a vector of corresponding normalized MCC, and a vector of corresponding F1.
}
\description{
This function creates the "mccf1" object.
}
\examples{
response <- c(rep(1, 1000), rep(0, 10000))
set.seed(2017)
predictor <- c(rbeta(300, 12, 2), rbeta(700, 3, 4), rbeta(10000, 2, 3))
x <- mccf1(response, predictor)
head(x$normalizedMCC)
# [1]  NaN 0.5150763 0.5213220 0.5261152 0.5301566 0.5337177
head(x$F1)
# [1]  NaN 0.001998002 0.003992016 0.005982054 0.007968127 0.009950249
head(x$thresholds)
# [1]  Inf 0.9935354 0.9931493 0.9930786 0.9925507 0.9900520
}
