% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_S3_methods.R
\name{coef.mcglm}
\alias{coef.mcglm}
\title{Model Coefficients}
\usage{
\method{coef}{mcglm}(
  object,
  std.error = FALSE,
  response = c(NA, 1:length(object$beta_names)),
  type = c("beta", "tau", "power", "correlation"),
  ...
)
}
\arguments{
\item{object}{an object of \code{mcglm} class.}

\item{std.error}{logical. If \code{TRUE} returns the standard errors
for the estimates. Default is \code{FALSE}.}

\item{response}{a numeric vector specifyng for which response
variable the coefficients should be returned.}

\item{type}{a string vector (can be 1 element length) specifying which
coefficients should be returned. \cr
Options are \code{"beta"}, \code{"tau"}, \code{"power"}, \code{"tau"} and
\code{"correlation"}.}

\item{...}{additional arguments affecting the summary produced. Note
that there is no extra options for \code{mcglm} object class.}
}
\value{
A \code{data.frame} with parameters names, estimates,
    response variable number and parameters type.
}
\description{
Extract model coefficients for objects
             of \code{mcglm} class.
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
