% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModalEM.R
\name{MclustMEM}
\alias{MclustMEM}
\alias{print.MclustMEM}
\alias{summary.MclustMEM}
\alias{print.summary.MclustMEM}
\title{Modal EM algorithm for Gaussian Mixtures fitted via \emph{mclust} package}
\usage{
MclustMEM(object, data = NULL, ...)

\method{summary}{MclustMEM}(object, ...)
}
\arguments{
\item{object}{An object of class \code{'Mclust'} or \code{'densityMclust'}
obtained by fitting a Gaussian mixture via, respectively, \code{\link[mclust:Mclust]{mclust::Mclust()}}
and \code{\link[mclust:densityMclust]{mclust::densityMclust()}}.}

\item{data}{If provided, a numeric vector, matrix, or data frame of
observations. If a matrix or data frame, rows correspond to observations
(\eqn{n}) and columns correspond to variables (\eqn{d}). If not provided,
the data used for fitting the Gaussian mixture model, and provided with the
\code{object} argument, are used.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
Returns an object of class \code{'MclustMEM'} with elements described in
\code{\link[=GaussianMixtureMEM]{GaussianMixtureMEM()}}.
}
\description{
Modal-clustering estimation by applying the Modal EM algorithm to Gaussian
mixtures fitted using the \emph{mclust} package.
}
\details{
For more details see
\code{vignette("mclustAddons")}
}
\examples{
\donttest{
data(Baudry_etal_2010_JCGS_examples, package = "mclust")

plot(ex4.1)
GMM <- Mclust(ex4.1)
plot(GMM, what = "classification")
MEM <- MclustMEM(GMM)
MEM
summary(MEM)
plot(MEM)

plot(ex4.4.2)
GMM <- Mclust(ex4.4.2)
plot(GMM, what = "classification")
MEM <- MclustMEM(GMM)
MEM
summary(MEM)
plot(MEM, addDensity = FALSE)
}
}
\references{
Scrucca L. (2021) A fast and efficient Modal EM algorithm for
Gaussian mixtures. \emph{Statistical Analysis and Data Mining}, 14:4,
305–314. \doi{doi:10.1002/sam.11527}
}
\seealso{
\code{\link[=GaussianMixtureMEM]{GaussianMixtureMEM()}}, \code{\link[=plot.MclustMEM]{plot.MclustMEM()}}.
}
\author{
Luca Scrucca
}
