% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{correlation}
\alias{correlation}
\alias{iid}
\alias{RW1}
\alias{RW2}
\alias{AR1}
\alias{season}
\alias{spatial}
\alias{spline}
\alias{custom}
\title{Correlation factor structures in generic model components}
\usage{
iid(name)

RW1(name, circular = FALSE, w = NULL)

RW2(name)

AR1(name, phi, w = NULL)

season(name, period)

spatial(name, poly.df, snap = sqrt(.Machine$double.eps), queen = TRUE)

spline(name, knots, degree)

custom(name, D = NULL, Q = NULL, R = NULL, derive.constraints = NULL)
}
\arguments{
\item{name}{name of a variable, unquoted.}

\item{circular}{whether the random walk is circular.}

\item{w}{a vector of weights.}

\item{phi}{value of an autoregressive parameter.}

\item{period}{a positive integer specifying the seasonal period.}

\item{poly.df}{a spatial data frame.}

\item{snap}{passed to \code{\link[spdep]{poly2nb}}.}

\item{queen}{passed to \code{\link[spdep]{poly2nb}}.}

\item{knots}{passed to \code{\link[splines]{splineDesign}}.}

\item{degree}{passed to \code{\link[splines]{splineDesign}}.}

\item{D}{custom incidence matrix.}

\item{Q}{custom precision matrix.}

\item{R}{custom restriction matrix.}

\item{derive.constraints}{whether to derive the constraint matrix for an
IGMRF model component numerically from the precision matrix.}
}
\description{
Element 'factor' of a model component created using function
\code{\link{gen}} is a formula composed of several possible terms described
below. It is used to derive a (typically sparse) precision matrix for a set of
coefficients, and possibly a matrix representing a set of linear constraints
to be imposed on the coefficient vector.
\describe{
  \item{iid(f)}{Independent effects corresponding to the levels of factor \code{f}.}
  \item{RW1(f, circular=FALSE, w=NULL)}{First-order random walk over the levels of factor \code{f}.
    The random walk can be made circular and different (fixed) weights can be attached to the innovations.
    If specified, \code{w} must be a positive numeric vector of length one less than the number of
    factor levels. For example, if the levels correspond to different times, it would often be
    reasonable to choose \code{w} proportional to the reciprocal time differences. For equidistant
    times there is generally no need to specify \code{w}.}
  \item{RW2(f)}{Second-order random walk.}
  \item{AR1(f, phi, w=NULL)}{First-order autoregressive correlation structure among
    the levels of \code{f}. Required argument is the (fixed) autoregressive parameter \code{phi}.
    For irregularly spaced AR(1) processes weights can be specified, in the same way as for
    \code{RW1}.}
  \item{season(f, period)}{Dummy seasonal with period \code{period}.}
  \item{spatial(f, poly.df, snap, queen, derive.constraints=FALSE)}{CAR spatial correlation.
    Argument \code{poly.df} can either be an object of (S4) class \code{SpatialPolygonsDataFrame}
    or an object of (S3) class \code{sf}. The latter can be obtained, e.g., from reading in a
    shape file using function \code{\link[sf]{st_read}}. Arguments \code{snap} and \code{queen}
    are passed to \code{\link[spdep]{poly2nb}}.
    If \code{derive.constraints=TRUE} the constraint matrix for an IGMRF model component
    is formed by computing the singular vectors of the precision matrix.}
  \item{spline(f, knots, degree)}{P-splines, i.e. penalized B-splines structure over
    the domain of a quantitative variable f. Arguments knots and degree are passed to
    \code{\link[splines]{splineDesign}}. If \code{knots} is a single value it is interpreted as
    the number of knots, otherwise as a vector of knot positions. By default 40 equally spaced
    knots are used, and a degree of 3.}
  \item{custom(f, D=NULL, Q=NULL, R=NULL, derive.constraints=NULL)}{Either a custom precision or incidence
    matrix associated with factor f can be passed to argument \code{Q} or \code{D}. Optionally a
    constraint matrix can be supplied as \code{R}, or constraints can be derived from the null space
    of the precision matrix by setting \code{derive.constraints=TRUE}.}
}
}
\examples{
\donttest{
# example of CAR spatial random effects
if (requireNamespace("sf")) {
  # 1. load a shape file of counties in North Carolina
  nc <- sf::st_read(system.file("shape/nc.shp", package="sf"))
  # 2. generate some data according to a model with a few regression
  # effects, as well as spatial random effects
  gd <- generate_data(
    ~ reg(~ AREA + BIR74, prior=pr_normal(precision=1), name="beta") +
      gen(factor = ~ spatial(NAME, poly.df=nc), name="vs"),
    sigma.mod = pr_invchisq(df=10, scale=1),
    data = nc
  )
  # add the generated target variable and the spatial random effects to the
  # spatial dataframe object
  nc$y <- gd$y
  nc$vs_true <- gd$pars$vs
  # 3. fit a model to the generated data, and see to what extent the
  #    parameters used to generate the data, gd$pars, are reproduced
  sampler <- create_sampler(
    y ~ reg(~ AREA + BIR74, prior=pr_normal(precision=1), name="beta") +
    gen(factor = ~ spatial(NAME, poly.df=nc), name="vs"),
    block=TRUE, data=nc
  )
  sim <- MCMCsim(sampler, store.all=TRUE, n.iter=600, n.chain=2, verbose=FALSE)
  (summ <- summary(sim))
  nc$vs <- summ$vs[, "Mean"]
  plot(nc[c("vs_true", "vs")])
  plot(gd$pars$vs, summ$vs[, "Mean"]); abline(0, 1, col="red")
}
}

}
\references{
B. Allevius (2018).
   On the precision matrix of an irregularly sampled AR(1) process.
   arXiv:1801.03791.

 H. Rue and L. Held (2005).
   Gaussian Markov Random Fields.
   Chapman & Hall/CRC.
}
