% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparison.R
\encoding{UTF-8}
\name{criterion}
\alias{criterion}
\alias{loo.mcpfit}
\alias{loo}
\alias{LOO}
\alias{waic.mcpfit}
\alias{waic}
\alias{WAIC}
\title{Compute information criteria for model comparison}
\usage{
criterion(fit, criterion = "loo", ...)

\method{loo}{mcpfit}(x, ...)

\method{waic}{mcpfit}(x, ...)
}
\arguments{
\item{fit}{An \code{\link{mcpfit}} object.}

\item{criterion}{One of \code{"loo"} (calls \code{\link[loo]{loo}}) or \code{"waic"} (calls \code{\link[loo]{waic}}).}

\item{...}{Currently ignored}

\item{x}{An \code{\link{mcpfit}} object.}
}
\value{
a \code{loo} or \code{psis_loo} object.
}
\description{
Takes an \code{\link{mcpfit}} as input and computes information criteria using loo or
WAIC. Compare models using \code{\link[loo]{loo_compare}} and \code{\link[loo]{loo_model_weights}}.
more in \code{\link[loo]{loo}}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{loo}: Computes loo on mcpfit objects

\item \code{waic}: Computes WAIC on mcpfit objects
}}

\examples{
\donttest{
# Define two models and sample them
# options(mc.cores = 3)  # Speed up sampling
model1 = list(y ~ 1 + x, ~ 1)
model2 = list(y ~ 1 + x)  # Without a change point
fit1 = mcp(model1, ex_plateaus)
fit2 = mcp(model2, ex_plateaus)

# Compute LOO for each and compare (works for waic(fit) too)
fit1$loo = loo(fit1)
fit2$loo = loo(fit2)
loo::loo_compare(fit1$loo, fit2$loo)
}

}
\seealso{
\code{\link{criterion}}

\code{\link{criterion}}
}
\author{
Jonas Kristoffer Lindeløv \email{jonas@lindeloev.dk}
}
