% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targets.R
\name{calc_rejection_rate}
\alias{calc_rejection_rate}
\title{Calculate Rejection Rate and its Monte Carlo Standard Error}
\usage{
calc_rejection_rate(p_values, alpha = 0.05)
}
\arguments{
\item{p_values}{A numeric vector of p-values from multiple hypothesis tests.}

\item{alpha}{The significance level used to determine if a p-value indicates a significant result.
Default is 0.05.}
}
\value{
A list with two components: `rejection_rate`, the proportion of tests that resulted in
rejection of the null hypothesis, and `rejection_rate_mcse`, the Monte Carlo Standard Error of the
rejection rate, providing an estimate of its variability.
}
\description{
Computes the rejection rate of hypotheses tests based on a vector of p-values and a specified
significance level (alpha). The rejection rate is the proportion of p-values that are lower than
alpha, indicating significant results. Additionally, the function calculates the Monte Carlo
Standard Error (MCSE) for the rejection rate, which quantifies the uncertainty associated with
the estimated rejection rate. This function is useful for assessing the overall type I error rate
or the power of a statistical test across multiple simulations or experimental replications.
}
\examples{
set.seed(123) # For reproducibility
p_values <- runif(100, min = 0, max = 1) # Simulated p-values
rejection_info <- calc_rejection_rate(p_values)
print(rejection_info)
}
