% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls.R
\name{categorize.pls}
\alias{categorize.pls}
\title{Categorize data rows based on PLS results and critical limits for total distance.}
\usage{
\method{categorize}{pls}(obj, res = obj$res$cal, ncomp = obj$ncomp.selected, ...)
}
\arguments{
\item{obj}{object with PCA model}

\item{res}{object with PCA results}

\item{ncomp}{number of components to use for the categorization}

\item{...}{other parameters}
}
\value{
vector (factor) with results of categorization.
}
\description{
The method uses full distance for decomposition of X-data and squared Y-residuals of PLS results
from \code{res} with critical limits computed for the PLS model and categorizes the
corresponding objects as "regular", "extreme" or "outlier".
}
\details{
The method does not categorize hidden values if any. It is based on the approach described in
[1] and works only if data driven approach is used for computing critical limits.
}
\references{
1. Rodionova O. Ye., Pomerantsev A. L. Detection of Outliers in Projection-Based Modeling.
Analytical Chemistry (2020, in publish). doi: 10.1021/acs.analchem.9b04611
}
