% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcrals.R
\name{mcrals.cal}
\alias{mcrals.cal}
\title{Identifies pure variables}
\usage{
mcrals.cal(
  D,
  ncomp,
  cont.constraints,
  spec.constraints,
  spec.ini,
  cont.forced,
  spec.forced,
  cont.solver,
  spec.solver,
  max.niter,
  tol,
  verbose
)
}
\arguments{
\item{D}{matrix with the spectra}

\item{ncomp}{number of pure components}

\item{cont.constraints}{a list with constraints to be applied to contributions  (see details).}

\item{spec.constraints}{a list with constraints to be applied to spectra  (see details).}

\item{spec.ini}{a matrix with initial estimation of the pure components spectra.}

\item{cont.forced}{a matrix which allows to force some of the concentration values (see details).}

\item{spec.forced}{a matrix which allows to force some of the spectra values (see details).}

\item{cont.solver}{which function to use as a solver for resolving of pure components contributions (see detials).}

\item{spec.solver}{which function to use as a solver for resolving of pure components spectra (see detials).}

\item{max.niter}{maximum number of iterations.}

\item{tol}{tolerance, when explained variance change is smaller than this value, iterations stop.}

\item{verbose}{logical, if TRUE information about every iteration will be shown.}
}
\value{
The function returns a list with with following fields:
\item{ncomp }{number of pure components.}
\item{resspec}{matrix with resolved spectra.}
\item{rescont}{matrix with resolved contributions.}
\item{cont.constraints}{list with contribution constraints provided by user.}
\item{spec.constraints}{list with spectra constraints provided by user.}
\item{max.niter}{maximum number of iterations}
}
\description{
The method identifies indices of pure variables using the SIMPLISMA
algorithm.
}
