% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldecomp.R
\name{plotVariance.ldecomp}
\alias{plotVariance.ldecomp}
\title{Explained variance plot}
\usage{
\method{plotVariance}{ldecomp}(
  obj,
  type = "b",
  variance = "expvar",
  labels = "values",
  xticks = seq_len(obj$ncomp),
  show.plot = TRUE,
  ylab = "Explained variance, \%",
  ...
)
}
\arguments{
\item{obj}{object of \code{ldecomp} class.}

\item{type}{type of the plot}

\item{variance}{string, which variance to make the plot for ("expvar", "cumexpvar")}

\item{labels}{what to show as labels for plot objects.}

\item{xticks}{vector with ticks for x-axis}

\item{show.plot}{logical, shall plot be created or just plot series object is needed}

\item{ylab}{label for y-axis}

\item{...}{most of graphical parameters from \code{\link{mdaplot}} function can be used.}
}
\description{
Shows a plot with explained variance vs. number of components.
}
