% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.R
\name{prep.transform}
\alias{prep.transform}
\title{Transformation}
\usage{
prep.transform(data, fun, ...)
}
\arguments{
\item{data}{a matrix with data values}

\item{fun}{reference to a transformation function, e.g. `log` or `function(x) x^2`.}

\item{...}{optional parameters for the transformation function}
}
\value{
data matrix with transformed values
}
\description{
Transforms values from using any mathematical function (e.g. log).
}
\examples{
# generate a matrix with two columns
y <- cbind(rnorm(100, 10, 1), rnorm(100, 20, 2))

# apply log transformation
py1 = prep.transform(y, log)

# apply power transformation
py2 = prep.transform(y, function(x) x^-1.25)

# show distributions
par(mfrow = c(2, 3))
for (i in 1:2) {
   hist(y[, i], main = paste0("Original values, column #", i))
   hist(py1[, i], main = paste0("Log-transformed, column #", i))
   hist(py2[, i], main = paste0("Power-transformed, column #", i))
}

}
