% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotseries.R
\name{plotHotellingEllipse}
\alias{plotHotellingEllipse}
\title{Hotelling ellipse}
\usage{
plotHotellingEllipse(p, conf.lim = 0.95, col = "#a0a0a0", lty = 3, ...)
}
\arguments{
\item{p}{plot series (e.g. from PCA scores plot)}

\item{conf.lim}{confidence limit}

\item{col}{color of the ellipse line}

\item{lty}{line type (e.g. 1 for solid, 2 for dashed, etc.)}

\item{...}{any argument suitable for \code{lines} function}
}
\description{
Add Hotelling ellipse to a scatter plot
}
\details{
The method is created to be used with PCA and PLS scores plots, so it shows the statistical
limits computed using Hotelling T^2 distribution in form of ellipse. The function works similar
to \code{\link{plotConvexHull}} and \code{\link{plotConfidenceEllipse}} but does not require
grouping of data points. Can be used together with functions \code{\link{plotScores.pca}},
\code{\link{plotScores.ldecomp}}, \code{\link{plotXScores.pls}},
\code{\link{plotXScores.plsres}}.

See examples for more details.
}
\examples{

# create PCA model for People data
data(people)
m <- pca(people, 4, scale = TRUE)

# make scores plot and show Hotelling ellipse with default settings
p <- plotScores(m, xlim = c(-8, 8), ylim = c(-8, 8))
plotHotellingEllipse(p)

# make scores plot and show Hotelling ellipse with manual settings
p <- plotScores(m, xlim = c(-8, 8), ylim = c(-8, 8))
plotHotellingEllipse(p, conf.lim = 0.99, col = "red")

# in case if you have both calibration and test set, 'plotScores()' returns
# plot series data for both, so you have to subset it and take the first series
# (calibration set) as shown below.
ind <- seq(1, 32, by = 4)
xc <- people[-ind, , drop = FALSE]
xt <- people[ind, , drop = FALSE]
m <- pca(xc, 4, scale = TRUE, x.test = xt)

p <- plotScores(m, xlim = c(-8, 8), ylim = c(-8, 8))
plotHotellingEllipse(p[[1]])

}
