% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls.R
\name{setDistanceLimits.pls}
\alias{setDistanceLimits.pls}
\title{Compute and set statistical limits for residual distances.}
\usage{
\method{setDistanceLimits}{pls}(
  obj,
  lim.type = obj$lim.type,
  alpha = obj$alpha,
  gamma = obj$gamma,
  ...
)
}
\arguments{
\item{obj}{object with PLS model}

\item{lim.type}{type of limits ("jm", "chisq", "ddmoments", "ddrobust")}

\item{alpha}{significance level for detection of extreme objects}

\item{gamma}{significance level for detection of outliers (for data driven approach)}

\item{...}{other arguments}
}
\value{
Object models with the three fields updated.
}
\description{
Computes statisticsl limits for orthogonal and score distances (x-decomposition) and
orthogonal distance (y-decomposition) based on calibration set and assign the calculated
values as model properties.
}
\details{
The limits can be accessed as fields of model objects: \code{$Qlim}, \code{$T2lim}, and
\code{$Zlim}. Each is a matrix with four rows and \code{ncomp} columns. In case of limits
for x-decomposition, first row contains critical limits for extremes, second row - for outliers,
third row contains mean value for corresponding distances (or its robust estimate in case of
\code{lim.type = "ddrobust"}) and last row contains the degrees of freedom.
}
