/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.core.clusterings;

import multidendrograms.core.clusterings.HierarchicalClustering;
import multidendrograms.core.definitions.Dendrogram;
import multidendrograms.core.definitions.SymmetricMatrix;

public class Ward
extends HierarchicalClustering {
    public Ward(SymmetricMatrix symmetricMatrix, String[] stringArray, boolean bl, int n) {
        super(symmetricMatrix, stringArray, bl, n);
    }

    @Override
    protected double calculateProximity(Dendrogram dendrogram, Dendrogram dendrogram2) {
        return Math.sqrt(this.alphaTerm(dendrogram, dendrogram2) + this.betaTerm(dendrogram, dendrogram2) + this.betaTerm(dendrogram2, dendrogram));
    }

    private double alphaTerm(Dendrogram dendrogram, Dendrogram dendrogram2) {
        double d = 0.0;
        for (int i = 0; i < dendrogram.numberOfSubroots(); ++i) {
            Dendrogram dendrogram3 = dendrogram.getSubroot(i);
            for (int j = 0; j < dendrogram2.numberOfSubroots(); ++j) {
                Dendrogram dendrogram4 = dendrogram2.getSubroot(j);
                double d2 = this.getAlpha(dendrogram, dendrogram3, dendrogram2, dendrogram4);
                double d3 = this.rootsProximity(dendrogram3, dendrogram4);
                d += d2 * d3 * d3;
            }
        }
        return d;
    }

    private double betaTerm(Dendrogram dendrogram, Dendrogram dendrogram2) {
        double d = 0.0;
        for (int i = 0; i < dendrogram.numberOfSubroots() - 1; ++i) {
            Dendrogram dendrogram3 = dendrogram.getSubroot(i);
            for (int j = i + 1; j < dendrogram.numberOfSubroots(); ++j) {
                Dendrogram dendrogram4 = dendrogram.getSubroot(j);
                double d2 = this.getBeta(dendrogram, dendrogram3, dendrogram4, dendrogram2);
                double d3 = this.rootsProximity(dendrogram3, dendrogram4);
                d += d2 * d3 * d3;
            }
        }
        return d;
    }

    private double getAlpha(Dendrogram dendrogram, Dendrogram dendrogram2, Dendrogram dendrogram3, Dendrogram dendrogram4) {
        return (double)(dendrogram2.numberOfLeaves() + dendrogram4.numberOfLeaves()) / (double)(dendrogram.numberOfLeaves() + dendrogram3.numberOfLeaves());
    }

    private double getBeta(Dendrogram dendrogram, Dendrogram dendrogram2, Dendrogram dendrogram3, Dendrogram dendrogram4) {
        return -((double)dendrogram4.numberOfLeaves() / (double)dendrogram.numberOfLeaves()) * (double)(dendrogram2.numberOfLeaves() + dendrogram3.numberOfLeaves()) / (double)(dendrogram.numberOfLeaves() + dendrogram4.numberOfLeaves());
    }
}

