/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.dendrogram;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import multidendrograms.core.definitions.Dendrogram;
import multidendrograms.core.utils.MathUtils;
import multidendrograms.utils.NumberUtils;

public class ToTxt {
    private Dendrogram root;
    private PrintWriter printWriter;

    public ToTxt(Dendrogram dendrogram) {
        this.root = dendrogram;
    }

    public void saveAsTxt(String string) throws IOException {
        File file = new File(string);
        FileWriter fileWriter = new FileWriter(file);
        this.printWriter = new PrintWriter(fileWriter);
        this.showCluster(this.root, "");
        this.printWriter.close();
    }

    private void showCluster(Dendrogram dendrogram, String string) {
        String string2 = string;
        if (dendrogram.numberOfSubclusters() == 1) {
            string2 = string2 + "*  " + dendrogram.getLabel();
        } else {
            double d;
            double d2 = dendrogram.getRootBottomHeight();
            if (d2 > (d = dendrogram.getRootTopHeight())) {
                double d3 = d2;
                d2 = d;
                d = d3;
            }
            int n = this.root.precision;
            d2 = MathUtils.round(d2, n);
            d = MathUtils.round(d, n);
            String string3 = NumberUtils.format(d2, n);
            String string4 = NumberUtils.format(d, n);
            string2 = string2 + "+ " + dendrogram.numberOfSubclusters() + "  [" + string3 + ", " + string4 + "]  " + dendrogram.numberOfLeaves();
        }
        this.printWriter.println(string2);
        if (dendrogram.numberOfSubclusters() > 1) {
            for (int i = 0; i < dendrogram.numberOfSubclusters(); ++i) {
                this.showCluster(dendrogram.getSubcluster(i), string + "  ");
            }
        }
    }
}

