/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.forms;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import multidendrograms.definitions.Config;
import multidendrograms.definitions.SettingsInfo;
import multidendrograms.dendrogram.DendrogramMeasures;
import multidendrograms.dendrogram.ToJson;
import multidendrograms.dendrogram.ToNewick;
import multidendrograms.dendrogram.ToTxt;
import multidendrograms.dendrogram.UltrametricMatrix;
import multidendrograms.dendrogram.eps.EpsExporter;
import multidendrograms.direct.DirectClustering;
import multidendrograms.forms.DendrogramFrame;
import multidendrograms.forms.DendrogramParameters;
import multidendrograms.forms.children.DendrogramMeasuresBox;
import multidendrograms.forms.children.DendrogramPanel;
import multidendrograms.forms.panels.InfoExitPanel;
import multidendrograms.forms.panels.LoadUpdatePanel;
import multidendrograms.forms.panels.SettingsPanel;
import multidendrograms.forms.scrollabledesktop.JScrollableDesktopPane;
import multidendrograms.initial.InitialProperties;
import multidendrograms.initial.Language;
import multidendrograms.initial.LogManager;
import multidendrograms.types.MethodType;
import multidendrograms.types.OriginType;

public class PrincipalDesk
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final int xOffset = 8;
    private static final int yOffset = 8;
    private static final int xDelta = 14;
    private static final int yDelta = 14;
    private static final int xRep = 100;
    private static final int yRep = 20;
    private static final int minFrmWidth = 700;
    private static final int minFrmHeight = 750;
    private final JPanel panControl;
    private final JPanel panInfoExit;
    private final JScrollableDesktopPane panDesk;
    private final LoadUpdatePanel panLoadUpdate;
    private final SettingsPanel panSettings;
    private DendrogramFrame currentDendrogramFrame;

    public PrincipalDesk(String string) {
        super(string);
        LogManager.LOG.info("Creating PrincipalDesk");
        int n = InitialProperties.getWidthMainWindow();
        int n2 = InitialProperties.getHeightMainWindow();
        this.panDesk = new JScrollableDesktopPane();
        this.panDesk.setBorder(BorderFactory.createTitledBorder(""));
        this.getContentPane().add(this.panDesk);
        this.panControl = new JPanel();
        this.panControl.setLayout(new BorderLayout());
        this.panLoadUpdate = new LoadUpdatePanel(this);
        this.panSettings = new SettingsPanel();
        this.panInfoExit = new InfoExitPanel(this);
        this.panControl.add((Component)this.panLoadUpdate, "North");
        JScrollPane jScrollPane = new JScrollPane(this.panSettings);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.panControl.add((Component)jScrollPane, "Center");
        this.panControl.add((Component)this.panInfoExit, "South");
        this.add((Component)this.panControl, "West");
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.setMinimumSize(new Dimension(700, 750));
        this.setSize(n, n2);
        this.setVisible(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PrincipalDesk.this.toGoOut();
            }
        });
    }

    public DendrogramFrame createDendrogramFrame(boolean bl, MethodType methodType) {
        int n;
        int n2;
        int n3;
        int n4;
        if (bl) {
            n4 = this.currentDendrogramFrame.getX();
            n3 = this.currentDendrogramFrame.getY();
            n2 = this.currentDendrogramFrame.getWidth();
            n = this.currentDendrogramFrame.getHeight();
        } else {
            if (this.panDesk.getNumInternalFrames() == 0) {
                DendrogramFrame.openFrameCount = 1;
            }
            int n5 = DendrogramFrame.openFrameCount;
            n4 = 8 + 14 * ((n5 - 1) / 100) + 14 * ((n5 - 1) % 100);
            n3 = 8 + 14 * ((n5 - 1) % 20);
            n2 = InitialProperties.getWidthDendroWindow();
            n = InitialProperties.getHeightDendroWindow();
        }
        DendrogramFrame dendrogramFrame = new DendrogramFrame(methodType, bl);
        dendrogramFrame.setSize(n2, n);
        dendrogramFrame.setBackground(Color.BLUE);
        dendrogramFrame.setLayout(new BorderLayout());
        dendrogramFrame.addInternalFrameListener(this.panLoadUpdate);
        this.panDesk.add(dendrogramFrame, n4, n3);
        return dendrogramFrame;
    }

    public void toGoOut() {
        String string = Language.getLabel(0);
        int n = JOptionPane.showConfirmDialog(null, string, Language.getLabel(46), 0);
        if (n == 0) {
            LogManager.LOG.info("Exit");
            System.exit(0);
        }
    }

    public void savePicture(BufferedImage bufferedImage, String string, Config config) throws Exception {
        FileDialog fileDialog = new FileDialog((Frame)this, Language.getLabel(75) + " " + string.toUpperCase(), 1);
        String string2 = DirectClustering.getFilePrefix(LoadUpdatePanel.getFileNameNoExt(), config.getProximityType(), config.getPrecision(), config.getMethod(), config.getMethodParameter(), config.isWeighted());
        fileDialog.setFile(string2 + "." + string);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String string3 = fileDialog.getDirectory() + fileDialog.getFile();
            File file = new File(string3);
            try {
                ImageIO.write((RenderedImage)bufferedImage, string, file);
                LogManager.LOG.info("Image saved");
            }
            catch (IOException iOException) {
                String string4 = Language.getLabel(76);
                LogManager.LOG.throwing("PrincipalDesk", "savePicture(final BufferedImage buff, final String tipus)", iOException);
                throw new Exception(string4);
            }
            catch (Exception exception) {
                String string5 = Language.getLabel(77);
                LogManager.LOG.throwing("PrincipalDesk", "savePicture(final BufferedImage buff, final String tipus)", exception);
                throw new Exception(string5);
            }
        }
    }

    public void savePostScript(DendrogramPanel dendrogramPanel, Config config) throws Exception {
        FileDialog fileDialog = new FileDialog((Frame)this, Language.getLabel(75) + " EPS", 1);
        String string = DirectClustering.getFilePrefix(LoadUpdatePanel.getFileNameNoExt(), config.getProximityType(), config.getPrecision(), config.getMethod(), config.getMethodParameter(), config.isWeighted());
        fileDialog.setFile(string + ".eps");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String string2 = fileDialog.getDirectory() + fileDialog.getFile();
            try {
                new EpsExporter(config, dendrogramPanel, string2);
                LogManager.LOG.info("EPS image saved");
            }
            catch (Exception exception) {
                String string3 = Language.getLabel(77);
                LogManager.LOG.throwing("PrincipalDesk", "savePostScript(final BufferedImage buff)", exception);
                throw new Exception(string3);
            }
        }
    }

    public void saveTXT(Config config) throws Exception {
        FileDialog fileDialog = new FileDialog((Frame)this, Language.getLabel(75) + " TXT", 1);
        String string = DirectClustering.getFilePrefix(LoadUpdatePanel.getFileNameNoExt(), config.getProximityType(), config.getPrecision(), config.getMethod(), config.getMethodParameter(), config.isWeighted());
        fileDialog.setFile(string + "-tree.txt");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String string2 = fileDialog.getDirectory() + fileDialog.getFile();
            ToTxt toTxt = new ToTxt(config.getRoot());
            toTxt.saveAsTxt(string2);
        }
    }

    public void saveNewick(Config config) throws Exception {
        FileDialog fileDialog = new FileDialog((Frame)this, Language.getLabel(75) + " Newick", 1);
        String string = DirectClustering.getFilePrefix(LoadUpdatePanel.getFileNameNoExt(), config.getProximityType(), config.getPrecision(), config.getMethod(), config.getMethodParameter(), config.isWeighted());
        fileDialog.setFile(string + "-newick.txt");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String string2 = fileDialog.getDirectory() + fileDialog.getFile();
            SettingsInfo settingsInfo = config.getSettingsInfo();
            OriginType originType = settingsInfo.getOriginType();
            boolean bl = originType.equals((Object)OriginType.UNIFORM_ORIGIN);
            ToNewick toNewick = new ToNewick(config.getRoot(), bl);
            toNewick.saveAsNewick(string2);
        }
    }

    public void saveJson(Config config) throws Exception {
        FileDialog fileDialog = new FileDialog((Frame)this, Language.getLabel(75) + " JSON", 1);
        String string = DirectClustering.getFilePrefix(LoadUpdatePanel.getFileNameNoExt(), config.getProximityType(), config.getPrecision(), config.getMethod(), config.getMethodParameter(), config.isWeighted());
        fileDialog.setFile(string + ".json");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String string2 = fileDialog.getDirectory() + fileDialog.getFile();
            SettingsInfo settingsInfo = config.getSettingsInfo();
            OriginType originType = settingsInfo.getOriginType();
            boolean bl = originType.equals((Object)OriginType.UNIFORM_ORIGIN);
            ToJson toJson = new ToJson(config.getRoot(), bl);
            toJson.saveAsJson(string2);
        }
    }

    public void saveUltrametricTxt(Config config) throws Exception {
        FileDialog fileDialog = new FileDialog((Frame)this, Language.getLabel(75) + " TXT", 1);
        String string = DirectClustering.getFilePrefix(LoadUpdatePanel.getFileNameNoExt(), config.getProximityType(), config.getPrecision(), config.getMethod(), config.getMethodParameter(), config.isWeighted());
        fileDialog.setFile(string + "-ultrametric.txt");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String string2 = fileDialog.getDirectory() + fileDialog.getFile();
            DendrogramParameters dendrogramParameters = this.currentDendrogramFrame.getDendrogramParameters();
            UltrametricMatrix ultrametricMatrix = dendrogramParameters.getUltrametricMatrix();
            ultrametricMatrix.saveAsTxt(string2);
        }
    }

    public void saveDendrogramMeasures(Config config) throws Exception {
        FileDialog fileDialog = new FileDialog((Frame)this, Language.getLabel(75) + " TXT", 1);
        String string = DirectClustering.getFilePrefix(LoadUpdatePanel.getFileNameNoExt(), config.getProximityType(), config.getPrecision(), config.getMethod(), config.getMethodParameter(), config.isWeighted());
        fileDialog.setFile(string + "-measures.txt");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String string2 = fileDialog.getDirectory() + fileDialog.getFile();
            DendrogramParameters dendrogramParameters = this.currentDendrogramFrame.getDendrogramParameters();
            UltrametricMatrix ultrametricMatrix = dendrogramParameters.getUltrametricMatrix();
            DendrogramMeasures dendrogramMeasures = new DendrogramMeasures(config.getExternalData().getProximityMatrix(), config.getRoot(), ultrametricMatrix.getMatrix());
            dendrogramMeasures.save(string2);
        }
    }

    public void showDendrogramMeasures(Config config) {
        DendrogramParameters dendrogramParameters = this.currentDendrogramFrame.getDendrogramParameters();
        UltrametricMatrix ultrametricMatrix = dendrogramParameters.getUltrametricMatrix();
        DendrogramMeasuresBox dendrogramMeasuresBox = new DendrogramMeasuresBox(ultrametricMatrix, config);
        dendrogramMeasuresBox.setVisible(true);
    }

    public SettingsPanel getPanMenu() {
        return this.panSettings;
    }

    public JScrollableDesktopPane getPanDesk() {
        return this.panDesk;
    }

    public void setCurrentFrame(DendrogramFrame dendrogramFrame) {
        this.currentDendrogramFrame = dendrogramFrame;
    }

    public LoadUpdatePanel getLoadUpdatePanel() {
        return this.panLoadUpdate;
    }

    public int getNumDendrogramFrames() {
        return this.panDesk.getNumInternalFrames();
    }
}

