% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processProposalWindows.R
\name{processProposalWindows}
\alias{processProposalWindows}
\title{Process proposal windows}
\usage{
processProposalWindows(proposal_windows, types)
}
\arguments{
\item{proposal_windows}{List of the proposal windows for the Metropolis-Hastings
sampling of Gaussian process hyperparameters. Each entry corresponds to a
view. For views modelled using a Gaussian process, the first entry is the
proposal window for the ampltiude, the second is for the length-scale and the
third is for the noise. These are not used in other mixture types.}

\item{types}{Character vector indicating density types to use. 'G' (Gaussian
with diagonal covariance matrix) 'MVN' (multivariate normal), 'TAGM'
(t-adjust Gaussian mixture), 'GP' (MVN with Gaussian process prior on the
mean), 'TAGPM' (TAGM with GP prior on the mean), 'C' (categorical).}
}
\value{
List of vectors of proposal windwos (for GP or TAGPM mixtures) or
NULLs (all other types).
}
\description{
Internal function to check that the proposal windows passed to
MDI are of the expected type. If the default is used then the GP
hyper-parameters have proposal windows 0.125 (ampltidue), 0.15 (length-scale),
and 0.1 (noise).
}
\examples{
V <- 3
proposal_windows <- vector("list", V)
types <- c("GP", "MVN", "C")
proposal_windows[[1]] <- c(0.15, 0.20, 0.10)
processProposalWindows(proposal_windows, types)

}
