% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.mds_ts}
\alias{plot.mds_ts}
\title{Plot MD-PMS Time Series}
\usage{
\method{plot}{mds_ts}(x, mode = "nA", xlab = "Time", ylab = "Count",
  main = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{mds_ts}.}

\item{mode}{Series to plot. Valid values are: \code{'nA'}, \code{'nB'},
\code{'nC'}, \code{'nD'}, \code{'exposure'}, \code{'rate'}. \code{'rate'} is
simply \code{'nA' / 'exposure'}. See details for more.

Default: \code{'nA'}}

\item{xlab}{x-axis label

#' Default: \code{'Time'}}

\item{ylab}{y-axis label

Default: \code{'Count'}}

\item{main}{Plot title

Default: \code{NULL} infers the title from \code{x} and \code{mode}.}

\item{...}{Further arguments to pass onto \code{plot()} generic.}
}
\description{
Quickly visualizes an MD-PMS times series of class \code{mds_ts}.
}
\details{
\code{mode} values defined as follows. Note: The following
definitions use a device-event pair as a working example, however it may also
be a covariate-device pair.
\describe{
  \item{'nA'}{Counts of the device-event pair.}
  \item{'nB'}{Counts of the device for all other events.}
  \item{'nC'}{Counts of all other devices for the event.}
  \item{'nD'}{Counts of all other devices for all other events.}
  \item{'exposure'}{Counts of exposure for the device-event pair.}
  \item{'rate'}{A crude rate, calculated as the device-event counts pair
  divided by the exposure counts.}
}
}
