#' Calculate the vulnerability of each node for each network
#'
#' @description
#' The vulnerability of each node represents the influence of the node on the global efficiency of the network, i.e. the efficiency of network after removing the targeted node.
#' For the detailed defination of global efficiency, please see the "Eff" option of measure parameter in \code{\link{robustness}} class.
#'
#' @param network_list a list with multiple networks; all the networks should be trans_network object created from \code{\link{trans_network}} class of \code{microeco} package.
#' @return data.frame
#' @examples
#' \donttest{
#' data(soil_amp_network)
#' vulnerability_table <- vulnerability(soil_amp_network)
#' }
#' @export
vulnerability <- function(network_list){
	check_input(network_list)
	res <- list()
	
	for(j in seq_along(network_list)){
		message("Network: ", names(network_list)[j], " ...")
		network <- network_list[[j]]$res_network
		
		all_node_names <- igraph::V(network)$name
		delete_node_names <- list()
		delete_node_names[["vul"]] <- lapply(all_node_names, function(x){x})
		tmp_network_del_list <- lapply(delete_node_names, function(y){
			lapply(y, function(x){
				igraph::delete_vertices(network, x)
			})
		})
		
		tmp_res <- measure_eff(tmp_network_del_list)
		tmp_res <- data.frame(Network = names(network_list)[j], Node = all_node_names, vulnerability = unlist(tmp_res$vul))
		res[[names(network_list)[j]]] <- tmp_res
	}
	res %<>% do.call(rbind, .)
	res[, 1] %<>% factor(., levels = names(network_list))
	res
}
