% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_network.R
\name{subset_network}
\alias{subset_network}
\title{Extract subset of network according to the edge intersection of networks}
\usage{
subset_network(network_list, venn = NULL, name = NULL)
}
\arguments{
\item{network_list}{a list with multiple networks; all the networks should be \code{trans_network} object created from \code{\link{trans_network}} class of microeco package.}

\item{venn}{default NULL; a \code{microtable} object which must be converted by \code{trans_comm} function of \code{trans_venn} class.}

\item{name}{default NULL; integer or character; must be a number or one of colnames of the \code{otu_table} in the input \code{venn} parameter.}
}
\value{
\code{trans_network} object, with only the extracted edges in the network
}
\description{
Extracting a network according to the edge intersection of networks.
}
\examples{
\donttest{
data(soil_amp_network)
# first obtain edge distribution
tmp <- edge_comp(soil_amp_network)
# obtain edge intersection using trans_venn class
tmp1 <- microeco::trans_venn$new(tmp)
# convert intersection result to microtable object
tmp2 <- tmp1$trans_comm()
# extract the intersection of all the three networks ("IW", "TW" and "CW")
test <- subset_network(soil_amp_network, venn = tmp2, name = "IW&TW&CW")
# test is a trans_network object
}
}
