% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3-mecor.R
\name{summary.mecor}
\alias{summary.mecor}
\title{Summarizing Measurement Error Correction}
\usage{
\method{summary}{mecor}(object, alpha = 0.05, zerovar = FALSE, fieller = FALSE, ...)
}
\arguments{
\item{object}{an object of class "mecor", a result of a call to
\link[mecor]{mecor}.}

\item{alpha}{probability of obtaining a type II error.}

\item{zerovar}{a boolean indicating whether standard errors and confidence
intervals using the zerovariance method must be added to the summary object.}

\item{fieller}{a boolean indicating whether confidence intervals using the
fieller method must be added to the summary object.}

\item{...}{additional arguments affecting the summary produced}
}
\value{
The function \code{summary.mecor} returns a list of summary statistics of the
fitted corrected model and fitted uncorrected model.

\item{call}{the matched call}
\item{c}{summary of the corrected fit}
\item{uc}{summary of the uncorrected fit}
\item{B}{number of bootstrap replicates used}
\item{alpha}{alpha level used}
}
\description{
\code{summary} method for class "mecor"
}
\examples{
## measurement error in a covariate:
# internal covariate-validation study
data(icvs)
mecor_fit <- mecor(Y ~ MeasError(X_star, reference = X) + Z,
                   data = icvs,
                   method = "standard")
summary(mecor_fit)
summary(mecor_fit, zerovar = TRUE, fieller = TRUE)
summary(mecor_fit, alpha = 0.10)

}
\seealso{
The model fitting function \link[mecor]{mecor}, \link[base]{summary}
}
