% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medExtractR-package.R
\docType{package}
\name{medExtractR-package}
\alias{medExtractR-package}
\alias{_PACKAGE}
\title{Medication Extraction With R}
\description{
Provides a function \code{\link{medExtractR}} for extracting
dose attributes for medications within a given electronic health record (EHR) note.
}
\examples{
\donttest{
note1 <- "Progrf Oral Capsule 1 mg 3 capsules by mouth twice a day - last
dose at 10pm"
note2 <- "Currently on lamotrigine 150-200, but will increase to lamotrigine 200mg bid"
medExtractR(note1, c("prograf", "tacrolimus"), 60, "mg", 2, lastdose=TRUE)
medExtractR(note2, c("lamotrigine", "ltg"), 130, "mg", 1, strength_sep = "-")
}
}
\author{
Hannah Weeks \email{hannah.l.weeks@vanderbilt.edu},\cr
Cole Beck \email{cole.beck@vumc.org},\cr
Leena Choi \email{leena.choi@vumc.org}

Maintainer: Hannah Weeks \email{hannah.l.weeks@vanderbilt.edu}
}
