% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_entities_tapering.R
\name{extract_entities_tapering}
\alias{extract_entities_tapering}
\title{Extract Medication Entities From Phrase - Extension of \code{\link{extract_entities}} for Tapering application}
\usage{
extract_entities_tapering(
  phrase,
  p_start,
  d_stop,
  unit,
  frequency_fun = NULL,
  intaketime_fun = NULL,
  duration_fun = NULL,
  route_fun = NULL,
  doseschedule_fun = NULL,
  preposition_fun = NULL,
  timekeyword_fun = NULL,
  transition_fun = NULL,
  dosechange_fun = NULL,
  strength_sep = NULL,
  ...
)
}
\arguments{
\item{phrase}{Text to search.}

\item{p_start}{Start position of phrase within original text.}

\item{d_stop}{End position of drug name within original text.}

\item{unit}{Unit of measurement for medication strength, e.g., \sQuote{mg}.}

\item{frequency_fun}{Function used to extract frequency.}

\item{intaketime_fun}{Function used to extract intake time.}

\item{duration_fun}{Function used to extract duration.}

\item{route_fun}{Function used to extract route.}

\item{doseschedule_fun}{Function used to extract dose schedule.}

\item{preposition_fun}{Function used to extract preposition.}

\item{timekeyword_fun}{Function used to extract time keyword.}

\item{transition_fun}{Function used to extract transition.}

\item{dosechange_fun}{Function used to extract dose change.}

\item{strength_sep}{Delimiter for contiguous medication strengths.}

\item{\dots}{Parameter settings used in extracting frequency and intake time,
including additional arguments to \code{frequency_fun} and
\code{intaketime_fun}. Use \code{frequency_dict} to identify custom frequency
dictionaries and \code{intaketime_dict } to identify custom intake time
dictionaries. Similarly, for all other entities with a corresponding \code{<entity>_fun},
a custom dictionary can be supplied with the argument \code{<entity>_dict}.}
}
\value{
data.frame with entities information. At least one row per entity is returned,
using \code{NA} when no expression was found for a given entity.\cr
The \dQuote{entity} column of the output contains the formatted label for that entity, according to
the following mapping.\cr
strength: \dQuote{Strength}\cr
dose amount: \dQuote{DoseAmt}\cr
dose strength: \dQuote{DoseStrength}\cr
frequency: \dQuote{Frequency}\cr
intake time: \dQuote{IntakeTime}\cr
duration: \dQuote{Duration}\cr
route: \dQuote{Route}\cr
dose change: \dQuote{DoseChange}\cr
dose schedule: \dQuote{DoseScheule}\cr
time keyword: \dQuote{TimeKeyword}\cr
transition: \dQuote{Transition}\cr
preposition: \dQuote{Preposition}\cr
dispense amount: \dQuote{DispenseAmt}\cr
refill: \dQuote{Refill}\cr
Sample output for the phrase \dQuote{Lamotrigine 200mg bid for 14 days} would look like:\cr
\tabular{rr}{
 entity   \tab  expr\cr
 IntakeTime  \tab  <NA>\cr
 Strength  \tab   <NA>\cr
 DoseAmt   \tab  <NA>\cr
 DoseChange   \tab  <NA>\cr
 DoseSchedule   \tab  <NA>\cr
 TimeKeyword   \tab  <NA>\cr
 Transition   \tab  <NA>\cr
 Preposition   \tab  <NA>\cr
 DispenseAmt   \tab  <NA>\cr
 Refill   \tab  <NA>\cr
 Frequency \tab  bid;19:22\cr
 DoseStrength  \tab  200mg;13:18\cr
 Preposition \tab for;23:26\cr
 Duration \tab 14 days;27:34
}
}
\description{
This function searches a phrase for medication dosing entities of interest. It
is called within \code{\link{medExtractR_tapering}} and generally not intended for use outside
that function.
}
\details{
Various medication dosing entities are extracted within this function
including the following:

\emph{strength}: The amount of drug in a given dosage form (i.e., tablet, capsule).\cr
\emph{dose amount}: The number of tablets, capsules, etc. taken at a given intake time.\cr
\emph{dose strength}: The total amount of drug given intake. This quantity would be
  equivalent to strength x dose amount, and appears similar to strength when
  dose amount is absent.\cr
\emph{frequency}: The number of times per day a dose is taken, e.g.,
  \dQuote{once daily} or \sQuote{2x/day}.\cr
\emph{intaketime}: The time period of the day during which a dose is taken,
  e.g., \sQuote{morning}, \sQuote{lunch}, \sQuote{in the pm}.\cr
\emph{duration}: How long a patient is on a drug regimen, e.g., \sQuote{2 weeks},
  \sQuote{mid-April}, \sQuote{another 3 days}.\cr
\emph{route}: The administration route of the drug, e.g., \sQuote{by mouth},
  \sQuote{IV}, \sQuote{topical}.\cr
\emph{dose change}: Whether the dosage of the drug was changed, e.g.,
  \sQuote{increase}, \sQuote{adjust}, \sQuote{reduce}.\cr
\emph{dose schedule}: Keywords which represent special dosing regimens, such as tapering
  schedules, alternating doses, or stopping keywords, e.g., \sQuote{weaning},
  \sQuote{even days} or \sQuote{odd_days}, \sQuote{discontinue}.\cr
\emph{time keyword}: Whether the dosing regimen is a past dose, current dose,
  or future dose, e.g., \sQuote{currently}, \sQuote{remain}, \sQuote{yesterday}.\cr
\emph{transition}: Words or symbols that link consecutive doses of a tapering
  regimen, e.g., \sQuote{then}, \sQuote{followed by}, or a comma \sQuote{,}.\cr
\emph{preposition}: Prepositions that occur immediately next to another
  identified entity, e.g., \sQuote{to}, \sQuote{until}, \sQuote{for}.\cr
\emph{dispense amount}: The number of pills prescribed to the patient.\cr
\emph{refill}: The number of refills allowed for the patient's prescription.\cr

Similar to the basic implementation, drug name and and time of last dose are not
handled by the \code{extract_entities_tapering} function. Those entities are extracted separately
and appended to the \code{extract_entities_tapering} output within the main \code{\link{medExtractR_tapering}}
function. In the tapering extension, however, dose change is treated the same as other dictionary-based
entities and extracted within \code{extract_entities_tapering}. Strength, dose amount, dose strength, dispense amount,
and refill are primarily numeric quantities, and are identified using a combination of
regular expressions and rule-based approaches. All other entities use dictionaries for
identification. For more information about the default dictionary for a specific entity,
view the documentation file for the object \code{<entity>_vals}.

By default and when an argument \code{<entity>_fun} is \code{NULL}, the
\code{\link{extract_generic}} function will be used to extract that entity. This function
can also inherit user-defined entity dictionaries for each entity, supplied as arguments \code{<entity>_dict}
to \code{\link{medExtractR}} or \code{\link{medExtractR_tapering}} (see documentation files for main function(s) for details).

Note that \code{extract_entities_tapering} has the argument \code{d_stop}. This differs
from \code{\link{extract_entities}}, which uses the end position of the full search window. This
is a consequence of \code{\link{medExtractR}} using a fixed search window length and \code{\link{medExtractR_tapering}}
dynamically constructing a search window.
}
\examples{
note <- "prednisone 20mg daily tapering to 5mg daily over 2 weeks"
extract_entities_tapering(note, 1, 11, "mg")
# A user-defined dictionary can be used instead of the default
my_dictionary <- data.frame(c("daily", "twice daily"))
extract_entities(note, 1, 11, "mg", frequency_dict = my_dictionary)
}
