% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize_landscape.R
\name{initialize_landscape}
\alias{initialize_landscape}
\title{Initialization of model inputs for spatially-distributed forest stands}
\usage{
initialize_landscape(
  x,
  SpParams,
  local_control,
  model = "spwb",
  simplify = FALSE,
  replace = FALSE,
  progress = TRUE
)
}
\arguments{
\item{x}{An object of class \code{\link{sf}} with the following columns:
\itemize{
\item{\code{geometry}: Spatial geometry.}
\item{\code{forest}: Objects of class \code{\link{forest}}.}
\item{\code{soil}: Objects of class \code{\link{soil}} or data frames of physical properties.}
\item{\code{land_cover_type}: Land cover type of each grid cell (values should be 'wildland' or 'agriculture').}
\item{\code{crop_factor}: Crop evapo-transpiration factor. Only required for 'agriculture' land cover type.}
\item{\code{local_control}: A list of control parameters (optional). Used to override function parameter \code{local_control} for specific cells (values can be \code{NULL} for the remaining ones).}
}}

\item{SpParams}{A data frame with species parameters (see \code{\link{SpParamsMED}}).}

\item{local_control}{A list of control parameters (see \code{\link{defaultControl}}).}

\item{model}{A string to indicate the model, either \code{"spwb"} or \code{"growth"}.}

\item{simplify}{Boolean flag to simplify forest to the tree and shrub cohorts with largest leaf area index. The leaf area index of the whole tree (respectively, shrub) layer will be attributed to the selected cohort.
See function \code{\link{forest_reduceToDominant}}.}

\item{replace}{Boolean flag to replace existing initialized states}

\item{progress}{Boolean flag to display progress information.}
}
\value{
Replaces or adds column 'state' whose elements are \code{\link{spwbInput}} or \code{\link{growthInput}} objects
and returns the modified object of class 'sf'.
}
\description{
Initializes state for local models \code{\link{spwb}} or \code{\link{growth}}.
}
\details{
Initialization is dealt automatically when calling simulation functions \code{\link{spwb_spatial}},  \code{\link{growth_spatial}},
\code{\link{spwb_spatial_day}} or \code{\link{growth_spatial_day}}. However, function \code{initialize_landscape}  allows separating initialization from model simulations.

Option \code{simplify} has been implemented to allow simplification of forests to tree/shrub dominant cohorts during watershed simulations
where focus is on runoff (e.g. calibration of watershed parameters or burnin periods). Elements identified as \code{result_cell} will not be simplified.
}
\examples{
# Load example landscape data
data("example_ifn")
  
# Load example meteo data frame from package meteoland
data("examplemeteo")
  
# Load default medfate parameters
data("SpParamsMED")
  
# Initialize state for 'spwb' simulations
example_ifn_init <- initialize_landscape(example_ifn, SpParamsMED, 
                                         defaultControl(), model = "spwb")

}
\seealso{
\code{\link{spwb_spatial}}, \code{\link{spwb_spatial_day}},
\code{\link{update_landscape}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
