% Generated by roxygen2 (4.0.2): do not edit by hand
\name{neWeight.default}
\alias{neWeight.default}
\title{Expand the dataset and calculate ratio-of-mediator probability weights}
\usage{
\method{neWeight}{default}(object, formula, data, nRep = 5,
  xSampling = c("quantiles", "random"), xFit, percLim = c(0.05, 0.95), ...)
}
\arguments{
\item{object}{fitted model object representing the mediator model.}

\item{formula}{a \code{\link[stats]{formula}} object providing a symbolic description of the mediator model. Redundant if already specified in call for fitted model specified in \code{object} (see details).}

\item{data}{data, as matrix or data frame, containing the exposure (and other relevant) variables. Redundant if already specified in call for fitted model specified in \code{object} (see details).}

\item{nRep}{number of replications or hypothetical values of the exposure to sample for each observation unit.}

\item{xSampling}{character string indicating how to sample from the conditional exposure distribution.
Possible values are \code{"quantiles"} or \code{"random"} (see details).}

\item{xFit}{an optional fitted object (preferably \code{glm}) for the conditional exposure distribution (see details).}

\item{percLim}{a numerical vector of the form \code{c(lower, upper)} indicating the extreme percentiles to sample when using \code{"quantiles"} as sampling method to sample from the conditional exposure distribution (see details).}

\item{...}{additional arguments.}
}
\value{
A data frame of class \code{c("data.frame", "expData", "weightData"))}. See \code{\link{expData}} for its structure.
}
\description{
This function both expands the data along hypothetical exposure values and calculates ratio-of-mediator probability weights.
}
\details{
The calculated weights are ratios of fitted probabilities or probability densities from the distribution of the mediator model.
This model needs to be specified as a fitted object in the \code{object} argument.

If the model-fitting function used to fit the mediator model does not require specification of a \code{formula} or \code{data} argument,
these need to be specified explicitly in order to enable \code{neWeight.default} to extract pointers to variable types relevant for mediation analysis.

Whether a \code{\link[stats]{formula}} is specified externally (in the call for the fitted mediator model object which is specified in \code{object}) or internally (via the \code{formula} argument),
it always needs to be of the form \code{M ~ X + C1 + C2}, with predictor variables entered in the following prespecified order:
\enumerate{
 \item exposure \code{X}: The first predictor is coded as exposure or treatment.
 \item baseline covariates \code{C}: All remaining predictor variables are automatically coded as baseline covariates.
}

In contrast to imputation models with categorical exposures, additional arguments need to be specified if the exposure is continuous.
All of these additional arguments are related to the sampling procedure for the exposure.

Whereas the number of replications \code{nRep} for categorical variables equals the number of levels for the exposure coded as a factor (i.e. the number of hypothetical exposure values), the number of desired replications needs to be specified explicitly for continuous exposures.
Its default is 5.

If \code{xFit} is left unspecified, the hypothetical exposure levels are automatically sampled from a linear model for the exposure, conditional on a linear combination of all covariates.
If one wishes to use another model for the exposure, this default model specification can be overruled by referring to a fitted model object in the \code{xFit} argument.
Misspecification of this sampling model does not induce bias in the estimated coefficients and standard errors of the natural effect model.

The \code{xSampling} argument allows to specify how the hypothetical exposure levels should be sampled from the conditional exposure distribution (which is either entered explicitly using the \code{xFit} argument or fitted automatically as described in the previous paragraph).
The \code{"random"} option randomly samples \code{nRep} draws from the exposure distribution, whereas the \code{"quantiles"} option (default) samples \code{nRep} quantiles at equal-sized probability intervals. Only the latter hence yields fixed exposure levels given \code{nRep} and \code{xFit}. \cr\cr
In order to guarantee that the entire support of the distribution is being sampled (which might be a concern if \code{nRep} is chosen to be small), the default lower and upper sampled quantiles are the 5th and 95th percentiles.
The intermittent quantiles correspond to equal-sized probability intervals. So, for instance, if \code{nRep = 4}, then the sampled quantiles will correspond to probabilities 0.05, 0.35, 0.65 and 0.95.
These default 'outer' quantiles can be changed by specifying the \code{percLim} argument accordingly. By specifying \code{percLim = NULL}, the standard quantiles will be sampled (e.g., 0.2, 0.4, 0.6 and 0.8 if \code{nRep = 4}).
}
\examples{
data(UPBdata)

## example using glm
fit.glm <- glm(negaffect ~ att + gender + educ + age, data = UPBdata)
weightData <- neWeight(fit.glm, nRep = 2)
weights <- attr(weightData, "weights")
head(cbind(weightData, weights))

## example using vglm (yielding identical results as with glm)
library(VGAM)
fit.vglm <- vglm(negaffect ~ att + gender + educ + age,
                 family = gaussianff, data = UPBdata)
weightData2 <- neWeight(fit.vglm, nRep = 2)
weights2 <- attr(weightData2, "weights")
head(cbind(weightData2, weights2))

\dontshow{fit1 <- glm(negaffect ~ att + gender + educ + age, data = UPBdata)
expData1 <- neWeight(fit1)
w1 <- attr(expData1, "weights")
expData1f <- neWeight(negaffect ~ att + gender + educ + age, data = UPBdata)
w1f <- attr(expData1f, "weights")
head(expData1); head(expData1f)
head(w1); head(w1f)

# test vglm (vglm is also vgam class, but not other way around!)
library(VGAM)
fit1b <- vgam(negaffect ~ att + gender + educ + age, family = gaussianff, data = UPBdata)
expData1b <- neWeight(fit1b)
head(attr(expData1, "weights")); head(attr(expData1b, "weights"))
fit1b <- vgam(negaffect ~ s(att) + gender + educ + age, family = gaussianff, data = UPBdata)
expData1b <- neWeight(fit1b)
head(attr(expData1, "weights")); head(attr(expData1b, "weights"))
expData1bf <- neWeight(negaffect ~ s(att) + gender + educ + age, FUN = vgam, family = gaussianff, data = UPBdata)
head(attr(expData1b, "weights")); head(attr(expData1bf, "weights"))
##

UPBdata$negaffect2 <- cut(UPBdata$negaffect, breaks = 2, labels = c("low", "high"))
fit2 <- glm(negaffect2 ~ att + gender + educ + age, family = binomial, data = UPBdata)
expData2 <- neWeight(fit2)
w2 <- attr(expData2, "weights")
expData2f <- neWeight(negaffect2 ~ att + gender + educ + age, family = binomial, data = UPBdata)
w2f <- attr(expData2f, "weights")
head(expData2); head(expData2f)
head(w2); head(w2f)

# test vglm
fit2b <- vgam(negaffect2 ~ att + gender + educ + age, family = binomialff, data = UPBdata)
expData2b <- neWeight(fit2b)
head(attr(expData2, "weights")); head(attr(expData2b, "weights"))
fit2b <- vgam(negaffect2 ~ s(att) + gender + educ + age, family = binomialff, data = UPBdata)
expData2b <- neWeight(fit2b)
head(attr(expData2, "weights")); head(attr(expData2b, "weights"))
expData2bf <- neWeight(negaffect2 ~ s(att) + gender + educ + age, FUN = vgam, family = binomialff, data = UPBdata)
head(attr(expData2b, "weights")); head(attr(expData2bf, "weights"))
##

UPBdata$negaffect3 <- cut(UPBdata$negaffect, breaks = 3, labels = c("low", "moderate", "high"))
UPBdata$negaffect3 <- as.numeric(UPBdata$negaffect3)
fit3 <- glm(negaffect3 ~ att + gender + educ + age, family = "poisson", data = UPBdata)
expData3 <- neWeight(fit3)
w3 <- attr(expData3, "weights")
expData3f <- neWeight(negaffect3 ~ att + gender + educ + age, family = poisson, data = UPBdata)
w3f <- attr(expData3f, "weights")
head(expData3); head(expData3f)
head(w3); head(w3f)

# test vglm
fit3b <- vgam(negaffect3 ~ att + gender + educ + age, family = poissonff, data = UPBdata)
expData3b <- neWeight(fit3b)
head(attr(expData3, "weights")); head(attr(expData3b, "weights"))
fit3b <- vgam(negaffect3 ~ s(att) + gender + educ + age, family = poissonff, data = UPBdata)
expData3b <- neWeight(fit3b)
head(attr(expData3, "weights")); head(attr(expData3b, "weights"))
expData3bf <- neWeight(negaffect3 ~ s(att) + gender + educ + age, FUN = vgam, family = poissonff, data = UPBdata)
head(attr(expData3b, "weights")); head(attr(expData3bf, "weights"))}
}
\seealso{
\code{\link{neWeight}}, \code{\link{neWeight.formula}}, \code{\link{expData}}
}

