% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{charlson_weights}
\alias{charlson_weights}
\title{Map of Charlson comorbidity categories to revised weights}
\format{A list, with Charlson comorbidities as names and weight as value}
\usage{
charlson_weights
}
\description{
List that links the Charlson comorbidity categories to revised 
weights as calculated by Schneeweiss in Table 4 of his paper.
}
\details{
Revised Schneeweiss weights:

0 = Connective tissue dz, Ulcer

1 = MI, PVD, CVD, Diabetes, Hemiplegia

2 = CHF, Chronic pulm dz, Mild liver dz, Diabetes with end organ damage, Any 
tumor, Leukemia, Lymphoma

3 = Dementia, Mod or severe renal dz

4 = Moderate or severe liver dz, AIDS

6 = Metastatic solid tumor
}
\examples{
charlson_weights["dementia"]
}
\references{
1. Schneeweiss S, Wang PS, Avorn J, Glynn RJ: Improved comorbidity adjustment 
  for predicting mortality
  in Medicare populations. Health services research 2003; 38:1103
  \url{http://www.ncbi.nlm.nih.gov/pubmed/12968819}
}
\seealso{
\code{\link{charlson_weights_orig}},
\code{\link{icd9cm_charlson_deyo}}, 
\code{\link{icd9cm_charlson_romano}},
\code{\link{icd9cm_charlson_quan}},
\code{\link{melt_icd9list}}
}
\keyword{datasets}

