% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icd9cm.R
\name{generate_charlson_index_df}
\alias{generate_charlson_index_df}
\title{Calculate the Charlson Comorbidity Index}
\usage{
generate_charlson_index_df(df, idvar = "id",
  weights = medicalrisk::charlson_weights)
}
\arguments{
\item{df}{a data frame with ID column \code{idvar} and logical columns for each 
comorbidity, such as that generated by \code{\link{generate_comorbidity_df}}}

\item{idvar}{string with name of ID variable within \code{df}}

\item{weights}{defaults to \code{\link{charlson_weights}}}
}
\value{
a dataframe with two columns, \code{idvar} and \code{"index"}
}
\description{
\code{generate_charlson_index_df} merges a data frame of Charlson 
comorbidities with \code{\link{charlson_weights}} and sums the results per 
patient.
}
\examples{
# calculate Charlson Comorbidity Index for all patients in the \\code{\\link{vt_inp_sample}}
data(vt_inp_sample)
generate_charlson_index_df(generate_comorbidity_df(vt_inp_sample))
}
\seealso{
\code{\link{generate_comorbidity_df}},
  \code{\link{charlson_weights}}, \code{\link{charlson_weights_orig}}
}

