% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{icd9cm_list}
\alias{icd9cm_list}
\title{List of ICD-9-CM diagnostic and procedural codes}
\format{A string vector}
\usage{
icd9cm_list
}
\description{
ICD-9-CM codes have the periods removed.  Diagnostic codes are prefixed with 
'D' while procedure codes are prefixed with 'P'. So, diagnostic code
\code{404.03} appears as \code{"D40403"}.
}
\details{
Obsolete codes not active in 2012 are not present, and may cause this dataset
to miss certain classifications when applied to older datasets.  For example, 
codes 043 and 044 (both obsolete AIDS codes) are not included.
}
\examples{
# Count procedural codes
length(icd9cm_list[grep('^P',icd9cm_list)])
}
\references{
1. \url{https://www.cms.gov/Medicare/Coding/ICD9ProviderDiagnosticCodes/codes.html}
}
\keyword{datasets}

