% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate-rsi.R
\name{sessler_get_single_beta}
\alias{sessler_get_single_beta}
\title{Returns the covariate coefficient for a particular diagnosis
or procedure code, along with the actual code that was found in
the internal database of coefficients. If a child code is supplied
but its parent is in the database, the coefficient for the parent
will be returned, along with that parent code. For example, if
D1231 is supplied but only D123 is available, D123 will be used.
This is apparently how the SPSS sample code works.}
\usage{
sessler_get_single_beta(code, betalist)
}
\arguments{
\item{code}{A single ICD-9-CM code}

\item{betalist}{One of the rsi_beta_* datasets (supplied with this package)}
}
\value{
Covariate coefficient. You must sum all of these for a given patient and then
    subtract the appropriate population beta (e.g. rsi_beta_1yrpod$popbeta)
}
\description{
Returns the covariate coefficient for a particular diagnosis
or procedure code, along with the actual code that was found in
the internal database of coefficients. If a child code is supplied
but its parent is in the database, the coefficient for the parent
will be returned, along with that parent code. For example, if
D1231 is supplied but only D123 is available, D123 will be used.
This is apparently how the SPSS sample code works.
}
\examples{
# get coefficient for hypercholesterolemia
sessler_get_single_beta('D2720', rsi_beta_inhosp)
# Also works with extra 0 on the end
sessler_get_single_beta('D27200', rsi_beta_inhosp)
}
