% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mx_search.R
\name{mx_search}
\alias{mx_search}
\title{Search preprint data}
\usage{
mx_search(
  data = NULL,
  query = NULL,
  fields = c("title", "abstract", "authors", "category", "doi"),
  from_date = NULL,
  to_date = NULL,
  auto_caps = FALSE,
  NOT = "",
  deduplicate = TRUE,
  report = FALSE
)
}
\arguments{
\item{data}{The preprint dataset that is to be searched, created either using
mx_api_content() or mx_snapshot()}

\item{query}{Character string, vector or list}

\item{fields}{Fields of the database to search - default is Title, Abstract,
Authors, Category, and DOI.}

\item{from_date}{Defines earliest date of interest. Written in the format
"YYYY-MM-DD". Note, records published on the date specified will also be
returned.}

\item{to_date}{Defines latest date of interest. Written in the format
"YYYY-MM-DD". Note, records published on the date specified will also be
returned.}

\item{auto_caps}{As the search is case sensitive, this logical specifies
whether the search should automatically allow for differing capitalisation
of search terms. For example, when TRUE, a search for "dementia" would find
both "dementia" but also "Dementia". Note, that if your term is multi-word
(e.g. "systematic review"), only the first word is automatically
capitalised (e.g your search will find both "systematic review" and
"Systematic review" but won't find "Systematic Review". Note that this
option will format terms in the query and NOT arguments (if applicable).}

\item{NOT}{Vector of regular expressions to exclude from the search. Default
is "".}

\item{deduplicate}{Logical. Only return the most recent version of a record.
Default is TRUE.}

\item{report}{Logical. Run mx_reporter. Default is FALSE.}
}
\description{
Search preprint data
}
\examples{
\donttest{
# Using the daily snapshot
mx_results <- mx_search(data = mx_snapshot(), query = "dementia")
}
}
\seealso{
Other main: 
\code{\link{mx_reporter}()},
\code{\link{print_full_results}()},
\code{\link{run_search}()}
}
\concept{main}
