% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/melviewr.R
\name{melviewr}
\alias{melviewr}
\title{melviewr: View and Classify Components from a Melodic Analysis}
\usage{
melviewr(melodic_dir, standard_file = NULL, motion_file = NULL)
}
\arguments{
\item{melodic_dir}{string Path to MELODIC output directory. This directory
must include a melodic_IC.nii or melodic_IC.nii.gz file.}

\item{standard_file}{string Optional path to a 3-dimensional Nifti standard file
of the same voxel dimensions as the melodic output}

\item{motion_file}{string Optional path to a summary motion text file. This file
should have one column and as many rows as there are volumes in the functional
data}
}
\value{
Invisibly returns a reference class object of class "Viewr"
}
\description{
The melviewr GUI allows for convenient viewing and classification of the
results of a single-subject MELODIC analysis. Classification can then be
saved to a text file for use by ICA+FIX to train its classifier. Various
graphics options are available in the GUI, and these settings can be saved
via a button in the GUI.
}
\details{
The directory specified in \code{melodic_dir} must contain a nifti
file called either "melodic_IC.nii.gz" or "melodic_IC.nii" for the GUI to run.
It must have a directory called "report" with text files inside in order to
display timecourse and powerspectrum plots. Normally, this directory is
created automatically with the \code{-report} flag in MELODIC.

When saving graphical settings, a JSON file is saved in the user's HOME
directory with the name: \code{.melviewR.config}
}
\examples{
\dontrun{
melodic_dir <- system.file("extdata", "example.ica", package = "melviewr")
standard_file <- system.file("extdata", "MNI152_T1_2mm_brain.nii.gz", package = "melviewr")
motion_file <- system.file("extdata", "Movement_RelativeRMS.txt", package = "melviewr")
melviewr(melodic_dir)
melviewr(melodic_dir, standard_file)
melviewr(melodic_dir, standard_file, motion_file)}
}

