% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BP_estim.R
\name{BP_estim}
\alias{BP_estim}
\title{Breakpoint estimators for a change in persistence}
\usage{
BP_estim(x, trend = c("none", "linear"), tau = 0.2, type = c("BT",
  "LKT", "LKSN", "MR"), direction = c("01", "10"), d_estim = c("GPH",
  "ELW"), d_bw = 0.7, m = 0, p = 0, twostep = c(FALSE, TRUE))
}
\arguments{
\item{x}{the univariate numeric time series to be investigated.}

\item{trend}{whether the time series exhibits a trend, \code{none} implies no trend and \code{linear} implies a linear trend.}

\item{tau}{the function searches in the interval \code{[T*tau,T*(1-tau)]} for a break in persistence with T being the length of the time series. It must hold that \code{0<tau<0.5}, default is \code{tau=0.2} as commonly used in the literature.}

\item{type}{which type of break point estimator should be used, \code{LKSN} for the estimator by Leybourne, Kim, Smith, and Newbold (2003), \code{BT} for the estimator by Busetti and Taylor (2004), \code{LKT} for the estimator by Leybourne, Kim, and Taylor (2006),
and \code{MR} for the estimator by Martins and Rodrigues (2014). See details.}

\item{direction}{direction of the change in persistence, \code{01} implies an increase in persistence over time and \code{10} a decrease. See details.}

\item{d_estim}{which estimator should be used to determine the order of integration in the two regimes, \code{GPH} corresponds to the estimator by Geweke and Porter-Hudak (1983) and \code{ELW} corresponds to the exact local Whittle estimator by Shimotsu and Phillips (2005).}

\item{d_bw}{bandwidth used for estimating the order of integration d. Default is \code{d_bw=0.7}.}

\item{m}{Number of covariances used for the estimation of the long run variance when considering the LKT estimator. Default is \code{m=0}.}

\item{p}{order of the AR-model used to account for serial correlation of the errors when considering the MR estimator. Default is \code{p=0}.}

\item{twostep}{boolean, indicating whether the two step procedure or the one step procedure should be used when considering the MR estimator. Default is \code{twostep=FALSE}.}
}
\value{
Returns a list that contains break point, estimate of the order of integration in the two regimes (the memory parameter d) and standard deviation of this estimate.
}
\description{
This function estimates the location where the investigated time series exhibits a break in persistence. It requires
knowledge of the direction of the break, i.e. an increase or decrease in persistence. This
needs to be determined beforehand using one of the various persistence change tests provided in this package.
}
\details{
The estimators BT and LKSN are only consistent for changes from I(0) to I(1) or vice versa, the LKT estimator is consistent for changes from stationary to nonstationary memory or vice versa (cf. also Sibbertsen and Kruse (2009)), and the MR estimator is consistent for changes in d in general.
}
\examples{
library(LongMemoryTS)
series<- c(rnorm(200),cumsum(rnorm(200)))
BP_estim(series,trend="none",type="BT",direction="01",d_estim="ELW")
}
\references{
Leybourne, S., Kim, T., Smith, V., and Newbold, P. (2003): Tests for a change in persistence against the null of difference-stationarity. Econometrics Journal, 6, pp. 291-311.

Busetti, F. and Taylor, R. (2004): Tests of stationarity against a change in persistence. Journal of Econometrics, 123, pp. 33-66.

Leybourne, S., Kim, T., and Taylor, R. (2006): Cusum of squares-based tests for a change in persistence. Journal of Time Series Analysis, 28, pp. 408-433.

Martins, L.. and Rodrigues, P. (2014): Testing for persistence change in fractionally integrated models: An application to world inflation rates Cusum of squares-based tests for a change in persistence. Computational Statistics and Data Analysis, 76, pp. 502-522.
}
\author{
Janis Becker
}
