% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memoiR.R
\name{Knit}
\alias{Knit}
\alias{knit_all}
\alias{knit_template}
\title{Knit}
\usage{
knit_all(destination = usethis::proj_path("docs"), gallery = "gallery")

knit_template(
  template,
  output_format,
  destination = usethis::proj_path("docs"),
  gallery = "gallery"
)
}
\arguments{
\item{destination}{name of the folder containing GitHub pages or equivalent.}

\item{gallery}{name of the subfolder of \code{destination} to store the knitted documents.}

\item{template}{name of the template to knit, e.g. "simple_article".}

\item{output_format}{A character vector of the output formats to convert to. Each value must be the name of a function producing an output format object, such as "bookdown::pdf_book".}
}
\value{
\code{TRUE} if all documents have been knitted and copied to the gallery, invisibly.
}
\description{
Create documents from templates
}
\details{
These functions are used to test the templates and produce a gallery.
\itemize{
\item \code{knit_template()} produces an HTML and a PDF output of the chosen template.
\item \code{knit_all()} runs knit_template() on all templates of the package.
The \code{output_format} argument selects the way templates are rendered:
\item articles may be rendered in HTML by \link[bookdown:html_document2]{bookdown::html_document2}, \link[bookdown:gitbook]{bookdown::gitbook}, \link[rmdformats:downcute]{rmdformats::downcute} (and others, see the package \strong{rmdformats}) and in PDF by \link[bookdown:pdf_book]{bookdown::pdf_book}.
\item books may be rendered in HTML by \link[bookdown:gitbook]{bookdown::gitbook} or \link[bookdown:bs4_book]{bookdown::bs4_book} and in PDF by \link[bookdown:pdf_book]{bookdown::pdf_book}.
\item slides may be rendered in  HTML by \link[bookdown:html_document2]{bookdown::slidy_presentation2}, \link[bookdown:html_document2]{bookdown::ioslides_presentation2} and in PDF by \link[bookdown:html_document2]{bookdown::beamer_presentation2}.
}

These functions are mainly used for test and documentation purposes.
In projects based on the templates, use the \emph{Knit} button (articles, presentations) or the \emph{Build the Book} button (memoirs) or \code{\link[bookdown:render_book]{bookdown::render_book()}}.
}
