% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructor.r
\name{Constructor}
\alias{Constructor}
\alias{mu}
\alias{mu,ANY-method}
\alias{mu,NULL-method}
\alias{mu,numeric-method}
\alias{mu,object_size-method}
\alias{mu,missing-method}
\alias{memuse}
\alias{memuse,ANY-method}
\alias{memuse,NULL-method}
\alias{memuse,missing-method}
\alias{memuse,numeric-method}
\alias{memuse,object_size-method}
\title{memuse Constructor}
\usage{
mu(size, unit = "best", prefix = "IEC", names = "short")

\S4method{mu}{ANY}(size, unit = "best", prefix = "IEC", names = "short")

\S4method{mu}{`NULL`}(size, unit = "best", prefix = "IEC", names = "short")

\S4method{mu}{numeric}(size, unit = "best", prefix = "IEC", names = "short")

\S4method{mu}{object_size}(size, unit = "best", prefix = "IEC", names = "short")

\S4method{mu}{missing}(size, unit = "best", prefix = "IEC", names = "short")

memuse(size, unit = "best", prefix = "IEC", names = "short")

\S4method{memuse}{ANY}(size, unit = "best", prefix = "IEC", names = "short")

\S4method{memuse}{`NULL`}(size, unit = "best", prefix = "IEC", names = "short")

\S4method{memuse}{missing}(size, unit = "best", prefix = "IEC", names = "short")

\S4method{memuse}{numeric}(size = size, unit = "best", prefix = "IEC", names = "short")

\S4method{memuse}{object_size}(size, unit = "best", prefix = "IEC", names = "short")
}
\arguments{
\item{size}{\code{numeric}; indicates the unit-multiple number of bytes used
by the object.}

\item{unit}{\code{string}; the unit of storage, such as "MiB" or "MB",
depending on prefix.  Case is ignored.}

\item{prefix}{\code{string}; the unit prefix, namely IEC or SI.  Case
is ignored.}

\item{names}{\code{string}; control for whether the unit names should
be printed out or their abbreviation should be used.  Options are "long" and
"short", respectively.  Case is ignored.}
}
\value{
Returns a \code{memuse} class object.
}
\description{
Constructor for objects of class \code{memuse}.
}
\details{
For numeric objects, if the length is 1, then its value is used
as the number of bytes.  Otherwise, the object's memory usage
in R is taken for the size parameter.
}
\examples{
\dontrun{
### The value passed as 'size' is the number of bytes
x <- memuse(100, unit="kb")
x

y <- memuse(100, unit="kb", prefix="SI")
y

### Use the memory usage of object 'size'
memuse(rnorm(1e4))
}

}
\seealso{
\code{ \link{memuse-class} \link{Accessors} \link{Converters} }
}
\keyword{Methods}
