% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitLm.R
\name{FitLm}
\alias{FitLm}
\alias{ResidLm}
\alias{Detrend}
\title{Fast estimates of linear regression}
\usage{
FitLm(y, ..., weights = NULL, se = FALSE, r2 = se)

ResidLm(y, ..., weights = NULL)

Detrend(y, time = seq_along(y))
}
\arguments{
\item{y}{numeric vector of observations to model}

\item{...}{numeric vectors of variables used in the modelling}

\item{weights}{numerical vector of weights (which doesn't need to be normalised)}

\item{se}{logical indicating whether to compute the standard error}

\item{r2}{logical indicating whether to compute r squared}

\item{time}{time vector to use for detrending. Only necessary in the case of
irregularly sampled timeseries}
}
\value{
FitLm returns a list with elements
\describe{
\item{term}{the name of the regressor}
\item{estimate}{estimate of the regression}
\item{std.error}{standard error}
\item{df}{degrees of freedom}
\item{r.squared}{Percent of variance explained by the model (repeated in each term)}
\item{adj.r.squared}{ r.squared` adjusted based on the degrees of freedom)}
}

ResidLm and Detrend returns a vector of the same length

If there's no complete cases in the regression, \code{NA}s are returned with no
warning.
}
\description{
Computes a linear regression with \link[stats:lmfit]{stats::.lm.fit} and returns the estimate
and, optionally, standard error for each regressor.
}
\examples{
# Linear trend with "signficant" areas shaded with points
library(data.table)
library(ggplot2)
system.time({
  regr <- geopotential[, FitLm(gh, date, se = TRUE), by = .(lon, lat)]
})

ggplot(regr[term != "(Intercept)"], aes(lon, lat)) +
    geom_contour(aes(z = estimate, color = after_stat(level))) +
    stat_subset(aes(subset = abs(estimate) > 2*std.error), size = 0.05)

# Using stats::lm() is much slower and with no names.
\dontrun{
system.time({
  regr <- geopotential[, coef(lm(gh ~ date))[2], by = .(lon, lat)]
})
}

}
