% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metR-package.R
\docType{package}
\name{metR}
\alias{metR-package}
\alias{metR}
\title{metR: Tools for Easier Analysis of Meteorological Fields}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Many useful functions and extensions for dealing with meteorological data in the tidy data framework. Extends 'ggplot2' for better plotting of scalar and vector fields and provides commonly used analysis methods in the atmospheric sciences.
}
\section{Overview}{

Conceptually it's divided into \emph{visualization tools} and \emph{data tools}.
The former are geoms, stats and scales that help with plotting using
'ggplot2', such as \link{stat_contour_fill} or \link{scale_y_level}, while the
later are functions for common data processing tools in the atmospheric
sciences, such as \link{Derivate} or \link{EOF}; these are implemented to work in the
'data.table' paradigm, but also work with regular data frames.

To get started, check the vignettes:
\itemize{
\item Visualization Tools: \code{vignette("Visualization-tools", package = "metR")}
\item Working with Data: \code{vignette("Working-with-data", package = "metR")    }
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://eliocamp.github.io/metR/}
  \item Report bugs at \url{https://github.com/eliocamp/metR/issues}
}

}
\author{
\strong{Maintainer}: Elio Campitelli \email{eliocampitelli@gmail.com} (\href{https://orcid.org/0000-0002-7742-9230}{ORCID})

}
