% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metareg.R
\name{metareg}
\alias{metareg}
\title{Meta-regression}
\usage{
metareg(
  x,
  formula,
  method.tau = x$method.tau,
  hakn = x$hakn,
  level.ma = x$level.ma,
  intercept = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{meta}.}

\item{formula}{Either a character string or a formula object.}

\item{method.tau}{A character string indicating which method is
used to estimate the between-study variance tau-squared. Either
\code{"FE"}, \code{"DL"}, \code{"REML"}, \code{"ML"},
\code{"HS"}, \code{"SJ"}, \code{"HE"}, or \code{"EB"}, can be
abbreviated.}

\item{hakn}{A logical indicating whether the method by Hartung and
Knapp should be used to adjust test statistics and confidence
intervals.}

\item{level.ma}{The level used to calculate confidence intervals
for parameter estimates in the meta-regression model.}

\item{intercept}{A logical indicating whether an intercept should
be included in the meta-regression model.}

\item{\dots}{Additional arguments passed to R function
\code{\link[metafor]{rma.uni}}.}
}
\value{
An object of class \code{c("metareg", "rma.uni", "rma")}. Please
look at the help page of R function \code{\link[metafor]{rma.uni}}
for more details on the output from this function.

In addition, a list \code{.meta} is added to the output containing
the following components:
\item{x, formula, method.tau, hakn, level.ma, intercept}{As
  defined above.}
\item{dots}{Information provided in argument '\dots{}'.}
\item{call}{Function call.}
\item{version}{Version of R package \bold{meta} used to create
  object.}
\item{version.metafor}{Version of R package \bold{metafor} used to
  create object.}
}
\description{
Meta-regression for objects of class \code{meta}. This is a wrapper
function for the R function \code{\link[metafor]{rma.uni}} in the R
package \bold{metafor} (Viechtbauer 2010).
}
\details{
This R function is a wrapper function for R function
\code{\link[metafor]{rma.uni}} in the R package \bold{metafor}
(Viechtbauer 2010).

Note, results are not back-transformed in printouts of
meta-analyses using summary measures with transformations, e.g.,
log risk ratios are printed instead of the risk ratio if argument
\code{sm = "RR"} and logit transformed proportions are printed if
argument \code{sm = "PLOGIT"}.

Argument '\dots{}' can be used to pass additional arguments to R
function \code{\link[metafor]{rma.uni}}. For example, argument
\code{control} to provide a list of control values for the
iterative estimation algorithm. See help page of R function
\code{\link[metafor]{rma.uni}} for more details.
}
\examples{
data(Fleiss1993cont)
# Add some (fictitious) grouping variables:
Fleiss1993cont$age <- c(55, 65, 55, 65, 55)
Fleiss1993cont$region <- c("Europe", "Europe", "Asia", "Asia", "Europe")

m1 <- metacont(n.psyc, mean.psyc, sd.psyc, n.cont, mean.cont, sd.cont,
  data = Fleiss1993cont, sm = "MD")
\dontrun{
# Warnings due to wrong ordering of arguments (order has changed
# with version 3.0-0 of R package meta)
#
metareg(~ region, m1)
metareg(~ region, data = m1)

# Warning as no information on covariate is available
#
metareg(m1)
}

# Do meta-regression for covariate region
#
mu2 <- update(m1, subgroup = region, tau.common = TRUE, common = FALSE)
metareg(mu2)

# Same result for
# - tau-squared
# - test of heterogeneity
# - test for subgroup differences
# (as argument 'tau.common' was used to create mu2)
#
mu2
metareg(mu2, intercept = FALSE)
metareg(m1, region)

# Different result for
# - tau-squared
# - test of heterogeneity
# - test for subgroup differences
# (as argument 'tau.common' is - by default - FALSE)
#
mu1 <- update(m1, subgroup = region)
mu1

# Generate bubble plot
#
bubble(metareg(mu2))

# Do meta-regression with two covariates
#
metareg(mu1, region + age)

# Do same meta-regressions using formula notation
#
metareg(m1, ~ region)
metareg(mu1, ~ region + age)

# Do meta-regression using REML method and print intermediate
# results for iterative estimation algorithm; furthermore print
# results with three digits.
#
metareg(mu1, region, method.tau = "REML",
  control = list(verbose = TRUE), digits = 3)

# Use Hartung-Knapp method
#
mu3 <- update(mu2, hakn = TRUE)
mu3
metareg(mu3, intercept = FALSE)

}
\references{
Viechtbauer W (2010):
Conducting Meta-Analyses in R with the Metafor Package.
\emph{Journal of Statistical Software},
\bold{36}, 1--48
}
\seealso{
\code{\link{bubble}}, \code{\link{summary.meta}},
  \code{\link{metagen}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
\keyword{models}
\keyword{regression}
