% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metabias.rm5.R
\name{metabias.rm5}
\alias{metabias.rm5}
\title{Cochrane review: Test for funnel plot asymmetry}
\usage{
\method{metabias}{rm5}(
  x,
  comp.no,
  outcome.no,
  method.bias = "linreg",
  method.bias.binary = method.bias,
  method.bias.or = "score",
  k.min = 10,
  ...
)
}
\arguments{
\item{x}{An object of class \code{rm5}.}

\item{comp.no}{Comparison number.}

\item{outcome.no}{Outcome number.}

\item{method.bias}{A character string indicating which test for
small-study effects is to be used for all outcomes. Either
\code{"rank"}, \code{"linreg"}, or \code{"mm"}, can be
abbreviated. See function \code{\link{metabias}}}

\item{method.bias.binary}{A character string indicating which test
is to be used for binary outcomes. Either \code{"rank"},
\code{"linreg"}, \code{"mm"}, \code{"count"}, \code{"score"}, or
\code{"peters"}, can be abbreviated. See function
\code{\link{metabias}}}

\item{method.bias.or}{A character string indicating which test is
to be used for binary outcomes with odds ratio as summary
measure. Either \code{"rank"}, \code{"linreg"}, \code{"mm"},
\code{"count"}, \code{"score"}, or \code{"peters"}, can be
abbreviated. See function \code{\link{metabias}}}

\item{k.min}{Minimum number of studies to perform test for
small-study effects.}

\item{...}{Additional arguments (ignored at the moment)}
}
\description{
Conduct a test for funnel plot asymmetry for all outcomes in a
Cochrane review
}
\details{
This function can be used to conduct a test for funnel plot
asymmetry for all or selected meta-analyses in a Cochrane Review.

Review Manager 5 (RevMan 5) was the software used for preparing and
maintaining Cochrane Reviews
(\url{https://training.cochrane.org/online-learning/core-software/revman}).
In RevMan 5, subgroup analyses can be defined and data from a
Cochrane review can be imported to R using the function
\code{read.rm5}.

The R function \code{\link{metacr}} is called internally.
}
\examples{
# Locate export data file "Fleiss1993_CR.csv" in sub-directory of
# package "meta"
#
filename <- system.file("extdata", "Fleiss1993_CR.csv", package = "meta")
Fleiss1993_CR <- read.rm5(filename)

# Print results for all tests of small-study effects
#
metabias(Fleiss1993_CR, k.min = 5)

# Print result of test of small-study effects for second outcome in
# first comparison
#
metabias(Fleiss1993_CR, comp.no = 1, outcome.no = 2, k.min = 5)

}
\references{
Higgins, J.P.T and S. Green (2011):
\emph{Cochrane Handbook for Systematic Reviews of Interventions
  Version 5.1.0 [Updated March 2011]}.
The Cochrane Library: http://www.cochrane-handbook.org/
}
\seealso{
\code{\link{metabias}}, \code{\link{metacr}},
  \code{\link{read.rm5}}, \code{\link{summary.rm5}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
\keyword{htest}
