% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.cdir.R
\name{read.cdir}
\alias{read.cdir}
\alias{print.cdir}
\title{Import data of Cochrane intervention review}
\usage{
read.cdir(
  file,
  title = "Cochrane Review of Interventions",
  exdir = tempdir(),
  numbers.in.labels = TRUE,
  rob = !missing(tool) | !missing(categories) | !missing(col) | !missing(symbols),
  tool = NULL,
  categories = NULL,
  col = NULL,
  symbols = NULL,
  keep.orig = FALSE,
  ...
)

\method{print}{cdir}(x, ...)
}
\arguments{
\item{file}{The name of a file to read data values from.}

\item{title}{Title of Cochrane review.}

\item{exdir}{The directory to extract files to (the equivalent of
‘unzip -d’). It will be created if necessary.}

\item{numbers.in.labels}{A logical indicating whether comparison
number and outcome number should be printed at the beginning of
the comparison (argument \code{complab}) and outcome label
(argument \code{outclab}); this is the default in RevMan Web.}

\item{rob}{A logical indicating whether risk of bias (RoB)
assessment should be considered in meta-analyses.}

\item{tool}{Risk of bias (RoB) tool.}

\item{categories}{Possible RoB categories.}

\item{col}{Colours for RoB categories.}

\item{symbols}{Corresponding symbols for RoB categories.}

\item{keep.orig}{A logical indicating whether to return the
original data files.}

\item{\dots}{Additional arguments (passed on to
\code{\link[utils]{unzip}})}

\item{x}{An object of class "cdir".}
}
\value{
A list consisting of a data frame 'data' with the study data and
(if available) a data frame 'rob' with information on the risk of
bias assessment. If \code{keep.orig = TRUE}, an additional list
'orig' is returned containing elements 'settings', 'datarows',
'subgroup' and 'rob' (if available).

The data frame 'data' contains the following variables:

\item{comp.no}{Comparison number.}
\item{outcome.no}{Outcome number.}
\item{group.no}{Group number.}
\item{studlab}{Study label.}
\item{year}{Year of publication.}
\item{event.e}{Number of events in experimental group.}
\item{n.e}{Number of observations in experimental group.}
\item{event.c}{Number of events in control group.}
\item{n.c}{Number of observations in control group.}
\item{mean.e}{Estimated mean in experimental group.}
\item{sd.e}{Standard deviation in experimental group.}
\item{mean.c}{Estimated mean in control group.}
\item{sd.c}{Standard deviation in control group.}
\item{O.E}{Observed minus expected (IPD analysis).}
\item{V}{Variance of \code{O.E} (IPD analysis).}
\item{TE, seTE}{Estimated treatment effect and standard error of
  individual studies.}
\item{lower, upper}{Lower and upper limit of 95\% confidence
  interval for treatment effect in individual studies.}
\item{weight}{Weight of individual studies (according to
  meta-analytical method used in respective meta-analysis - see
  details).}
\item{order}{Ordering of studies.}
\item{grplab}{Group label.}
\item{type}{Type of outcome. D = dichotomous, C = continuous, P =
  IPD.}
\item{method}{A character string indicating which method has been
  used for pooling of studies. One of \code{"Inverse"},
  \code{"MH"}, or \code{"Peto"}.}
\item{sm}{A character string indicating which summary measure has
  been used for pooling of studies.}
\item{model}{A character string indicating which meta-analytical
  model has been used (either \code{"Fixed"} or \code{"Random"}).}
\item{common}{A logical indicating whether common effect
  meta-analysis has been used in respective meta-analysis (see
  details).}
\item{random}{A logical indicating whether random effects
  meta-analysis has been used in respective meta-analysis (see
  details).}
\item{title}{Title of Cochrane review.}
\item{complab}{Comparison label.}
\item{outclab}{Outcome label.}
\item{label.e}{Label for experimental group.}
\item{label.c}{Label for control group.}
\item{label.left}{Graph label on left side of forest plot.}
\item{label.right}{Graph label on right side of forest plot.}

The data frame 'rob' contains the following variables:

\item{studlab}{Study label.}
\item{D1, D2, \dots}{Risk of bias domain 1, 2, \dots}
\item{D1.details, D2.details, \dots}{Details on risk of bias domain
  1, 2, \dots}
}
\description{
Reads Cochrane data package (version 1) of a Cochrane intervention
review and creates a data frame from it.
}
\details{
RevMan Web is the current software used for preparing and
maintaining Cochrane reviews
(\url{https://training.cochrane.org/online-learning/core-software/revman}).
RevMan Web includes the ability to write systematic reviews of
interventions or diagnostic test accuracy reviews.

This function provides the ability to read the Cochrane data
package from a Cochrane intervention review created with RevMan
Web. The ZIP-file is extracted with \code{\link[utils]{unzip}}.

Argument \code{title} can be used to overwrite the title of the
Cochrane review.

Information on the risk of bias (RoB) assessment can be provided
with arguments \code{tool}, \code{categories}, \code{col} and
\code{symbols}. This is only useful if (i) all outcomes are based
on the same RoB categories and (ii) an overall RoB assessment has
not been done. If no overall RoB assessment was conducted, R
function \code{\link{metacr}} can be used to provide the RoB
information for a single outcome. R function \code{\link{rob}} is
the most flexible way to add RoB information to a meta-analysis
object.

\subsection{Creation of Cochrane data package}{

Two possible ways exist to create the ZIP-file.

In RevMan Web (\url{https://revman.cochrane.org/}), press the
"Export" button at the bottom of the \emph{Default view}
website. After a couple of seconds, the data package will be shown
at the bottom of the \emph{Default view} website under "Downloads".

In the Cochrane Library (\url{https://www.cochranelibrary.com/}),
press on "Download statistical data" in the Contents menu to
download an rm5-file. This file can be converted to a data package
in RevMan Web using \emph{Help} - \emph{Convert a RevMan 5 file}.
}
}
\examples{
# Locate file "Fleiss1993.zip" with Cochrane data package in
# sub-directory of R package meta
#
filename <- system.file("extdata/Fleiss1993.zip", package = "meta")
Fleiss1993_CR <- read.cdir(filename)
Fleiss1993_CR

# Same result as R Command example(Fleiss1993bin):
#
metacr(Fleiss1993_CR)

# Same result as R Command example(Fleiss1993cont):
#
metacr(Fleiss1993_CR, 1, 2)

}
\references{
\url{https://documentation.cochrane.org/revman-kb/data-package-user-guide-243761660.html}

\url{https://documentation.cochrane.org/revman-kb/data-package-specification-249561249.html}
}
\seealso{
\code{\link{metacr}}, \code{\link{rob}},
  \code{\link{read.rm5}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
\keyword{datagen}
