% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_random.R
\name{meta_random}
\alias{meta_random}
\title{Bayesian Random-Effects Meta-Analysis}
\usage{
meta_random(y, SE, labels, data, d = prior("norm", c(mean = 0, sd =
  0.3)), tau = prior("invgamma", c(shape = 1, scale = 0.15)),
  rscale_contin = 1/2, rscale_discrete = sqrt(2)/2, centering = TRUE,
  logml = "integrate", summarize = "stan", ci = 0.95,
  rel.tol = .Machine$double.eps^0.3, logml_iter = 5000,
  silent_stan = TRUE, ...)
}
\arguments{
\item{y}{effect size per study. Can be provided as (1) a numeric vector, (2)
the quoted or unquoted name of the variable in \code{data}, or (3) a
\code{\link[stats]{formula}} to include discrete or continuous moderator
variables.}

\item{SE}{standard error of effect size for each study. Can be a numeric
vector or the quoted or unquoted name of the variable in \code{data}}

\item{labels}{optional: character values with study labels. Can be a
character vector or the quoted or unquoted name of the variable in
\code{data}}

\item{data}{data frame containing the variables for effect size \code{y},
standard error \code{SE}, \code{labels}, and moderators per study.}

\item{d}{\code{prior} distribution on the average effect size \code{d}. The
prior probability density function is defined via \code{\link{prior}}.}

\item{tau}{\code{prior} distribution on the between-study heterogeneity
\code{tau} (i.e., the standard deviation of the study effect sizes
\code{dstudy} in a random-effects meta-analysis. A (nonnegative) prior
probability density function is defined via \code{\link{prior}}.}

\item{rscale_contin}{scale parameter of the JZS prior for the continuous
covariates.}

\item{rscale_discrete}{scale parameter of the JZS prior for discrete
moderators.}

\item{centering}{whether continuous moderators are centered.}

\item{logml}{how to estimate the log-marginal likelihood: either by numerical
integration (\code{"integrate"}) or by bridge sampling using MCMC/Stan
samples (\code{"stan"}). To obtain high precision with \code{logml="stan"},
many MCMC samples are required (e.g., \code{logml_iter=10000, warmup=1000}).}

\item{summarize}{how to estimate parameter summaries (mean, median, SD,
etc.): Either by numerical integration (\code{summarize = "integrate"}) or
based on MCMC/Stan samples (\code{summarize = "stan"}).}

\item{ci}{probability for the credibility/highest-density intervals.}

\item{rel.tol}{relative tolerance used for numerical integration using
\code{\link[stats]{integrate}}. Use \code{rel.tol=.Machine$double.eps} for
maximal precision (however, this might be slow).}

\item{logml_iter}{number of iterations (per chain) from the posterior
distribution of \code{d} and \code{tau}. The samples are used for computing
the marginal likelihood of the random-effects model with bridge sampling
(if \code{logml="stan"}) and for obtaining parameter estimates (if
\code{summarize="stan"}). Note that the argument \code{iter=2000} controls
the number of iterations for estimation of the random-effect parameters per
study in random-effects meta-analysis.}

\item{silent_stan}{whether to suppress the Stan progress bar.}

\item{...}{further arguments passed to \code{rstan::sampling} (see
\code{\link[rstan]{stanmodel-method-sampling}}). Relevant MCMC settings
concern the number of warmup samples that are discarded
(\code{warmup=500}), the total number of iterations per chain
(\code{iter=2000}), the number of MCMC chains (\code{chains=4}), whether
multiple cores should be used (\code{cores=4}), and control arguments that
make the sampling in Stan more robust, for instance:
\code{control=list(adapt_delta=.97)}.}
}
\description{
Bayesian meta-analysis assuming that the effect size \eqn{d} varies across
studies with standard deviation \eqn{\tau} (i.e., a random-effects model).
}
\examples{
### Bayesian Random-Effects Meta-Analysis
# Note: The following code optimizes speed (for CRAN checks).
#       The settings are not suitable for actual data analysis!

data(towels)
set.seed(123)
mr <- meta_random(logOR, SE, study, data = towels,
                  d = prior("norm", c(mean=0, sd=.3), lower = 0),
                  tau = prior("invgamma", c(shape = 1, scale = 0.15)),
                  rel.tol=.Machine$double.eps^.15, iter=1000)
mr
plot_posterior(mr)
}
