% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_2x2.R
\name{es_from_2x2_prop}
\alias{es_from_2x2_prop}
\title{Convert the proportion of occurrence of a binary event in two independent groups into several effect size measures}
\usage{
es_from_2x2_prop(
  prop_cases_exp,
  prop_cases_nexp,
  n_exp,
  n_nexp,
  table_2x2_to_cor = "tetrachoric",
  reverse_prop
)
}
\arguments{
\item{prop_cases_exp}{proportion of cases/events in the exposed group (ranging from 0 to 1)}

\item{prop_cases_nexp}{proportion of cases/events in the non-exposed group (ranging from 0 to 1)}

\item{n_exp}{total number of participants in the exposed group}

\item{n_nexp}{total number of participants in the non exposed group}

\item{table_2x2_to_cor}{formula used to obtain a correlation coefficient from the contigency table (see details).}

\item{reverse_prop}{a logical value indicating whether the direction of generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab OR + RR + NNT\cr
\tab \cr
\code{converted effect size measure} \tab D + G + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 7. Contingency (2x2) table or proportions'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert the proportion of occurrence of a binary event in two independent groups into several effect size measures
}
\details{
This function uses the proportions and sample size to
recreate the 2x2 table, and
then relies on the calculations of the \code{\link{es_from_2x2_sum}()} function.

The formulas used is to obtain the 2x2 table are
\deqn{n\_cases\_exp = prop\_cases\_exp * n\_exp}
\deqn{n\_cases\_nexp = prop\_cases\_nexp * n\_nexp}
\deqn{n\_controls\_exp = (1 - prop\_cases\_exp) * n\_exp}
\deqn{n\_controls\_nexp = (1 - prop\_cases\_nexp) * n\_nexp}
}
\examples{
es_from_2x2_prop(prop_cases_exp = 0.80, prop_cases_nexp = 0.60, n_exp = 10, n_nexp = 20)
}
