% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_REGRESSION.R
\name{es_from_beta_unstd}
\alias{es_from_beta_unstd}
\title{Convert an unstandardized regression coefficient and the standard deviation of the dependent variable
into several effect size measures}
\usage{
es_from_beta_unstd(
  beta_unstd,
  sd_dv,
  n_exp,
  n_nexp,
  smd_to_cor = "viechtbauer",
  reverse_beta_unstd
)
}
\arguments{
\item{beta_unstd}{an unstandardized regression coefficient value (binary predictor, no other covariables in the model)}

\item{sd_dv}{standard deviation of the dependent variable}

\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{smd_to_cor}{formula used to convert the \code{cohen_d} value into a coefficient correlation (see details).}

\item{reverse_beta_unstd}{a logical value indicating whether the direction of the generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 13. (Un-)Standardized regression coefficient'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert an unstandardized regression coefficient and the standard deviation of the dependent variable
into several effect size measures
}
\details{
This function estimates a Cohen's d (D) and Hedges' g (G) from an unstandardized linear regression coefficient (coming from a model with only one binary predictor),
and the standard deviation of the dependent variable.
Odds ratio (OR) and correlation coefficients (R/Z) are then converted from the Cohen's d.

\strong{The formula used to obtain the Cohen's d is}:
\deqn{N = n\_exp + n\_nexp}
\deqn{sd\_pooled = \sqrt{\frac{sd\_dv^2 * (N - 1) - unstd\_beta^2 * \frac{n\_exp * n\_nexp}{N}}{N - 2}}}
\deqn{cohen\_d = \frac{unstd\_beta}{sd\_pooled}}

\strong{To estimate other effect size measures},
calculations of the \code{\link{es_from_cohen_d}()} are applied.
}
\examples{
es_from_beta_unstd(beta_unstd = 2.1, sd_dv = 0.98, n_exp = 20, n_nexp = 22)
}
\references{
Lipsey, M. W., & Wilson, D. B. (2001). Practical meta-analysis. Sage Publications, Inc.
}
