% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_stand_MD.R
\name{es_from_md_pval}
\alias{es_from_md_pval}
\title{Convert a mean difference between two independent groups and its p-value into several effect size measures}
\usage{
es_from_md_pval(
  md,
  md_pval,
  n_exp,
  n_nexp,
  smd_to_cor = "viechtbauer",
  reverse_md
)
}
\arguments{
\item{md}{mean difference between two independent groups}

\item{md_pval}{p-value of the mean difference}

\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{smd_to_cor}{formula used to convert the \code{cohen_d} value into a coefficient correlation (see details).}

\item{reverse_md}{a logical value indicating whether the direction of generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab MD + D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z\cr
\tab \cr
\code{required input data} \tab See 'Section 10. Mean difference and dispersion (crude)'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert a mean difference between two independent groups and its p-value into several effect size measures
}
\details{
This function converts the p-value of a mean difference
into a standard error (Cochrane Handbook section 6.5.2.3):
\deqn{t = qt(\frac{md\_pval}{2}, df = n\_exp + n\_nexp - 2)}
\deqn{md\_se = |\frac{md}{t}|}
Calculations of the \code{\link{es_from_md_se}} function are then used to estimate the Cohen's d and other effect size measures.
}
\examples{
es_from_md_pval(md = 4, md_pval = 0.024, n_exp = 20, n_nexp = 22)
}
\references{
Higgins JPT, Thomas J, Chandler J, Cumpston M, Li T, Page MJ, Welch VA (editors). Cochrane Handbook for Systematic Reviews of Interventions version 6.3 (updated February 2022). Cochrane, 2022. Available from www.training.cochrane.org/handbook.
}
